/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.config;

import io.scalecube.config.ObjectConfigProperty;
import io.scalecube.config.StringConfigProperty;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;

class MappedObjectConfigProperty<T>
implements ObjectConfigProperty<T> {
    private final StringConfigProperty configProperty;
    private final Function<String, T> mapper;

    MappedObjectConfigProperty(StringConfigProperty configProperty, Function<String, T> mapper) {
        this.configProperty = configProperty;
        this.mapper = mapper;
    }

    @Override
    public String name() {
        return this.configProperty.name();
    }

    @Override
    public Optional<T> value() {
        return this.configProperty.value().map(this.mapper);
    }

    @Override
    public T value(T defaultValue) {
        return this.value().orElse(defaultValue);
    }

    @Override
    public void addCallback(BiConsumer<T, T> callback) {
        this.configProperty.addCallback((String v0, String v1) -> {
            Object t0 = Optional.ofNullable(v0).map(this.mapper).orElse(null);
            Object t1 = Optional.ofNullable(v1).map(this.mapper).orElse(null);
            callback.accept(t0, t1);
        });
    }

    @Override
    public void addCallback(Executor executor, BiConsumer<T, T> callback) {
        this.configProperty.addCallback(executor, (String v0, String v1) -> {
            Object t0 = Optional.ofNullable(v0).map(this.mapper).orElse(null);
            Object t1 = Optional.ofNullable(v1).map(this.mapper).orElse(null);
            callback.accept(t0, t1);
        });
    }

    @Override
    public void addValidator(Predicate<T> validator) {
        this.configProperty.addValidator((String value) -> validator.test(Optional.ofNullable(value).map(this.mapper).orElse(null)));
    }
}

