/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.config;

import io.scalecube.config.AbstractConfigProperty;
import io.scalecube.config.ObjectConfigProperty;
import io.scalecube.config.ObjectPropertyField;
import io.scalecube.config.ObjectPropertyParser;
import io.scalecube.config.PropertyCallback;
import io.scalecube.config.source.LoadedConfigProperty;
import io.scalecube.config.utils.ThrowableUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

class ObjectConfigPropertyImpl<T>
extends AbstractConfigProperty<T>
implements ObjectConfigProperty<T> {
    ObjectConfigPropertyImpl(Map<String, String> bindingMap, Class<T> cfgClass, Map<String, LoadedConfigProperty> propertyMap, Map<String, Map<Class, PropertyCallback>> propertyCallbackMap) {
        super(cfgClass.getName(), cfgClass);
        List<ObjectPropertyField> propertyFields = this.toPropertyFields(bindingMap, cfgClass);
        this.setPropertyCallback(this.computePropertyCallback(cfgClass, propertyFields, propertyCallbackMap));
        this.computeValue(propertyFields.stream().map(ObjectPropertyField::getPropertyName).filter(propertyMap::containsKey).map(propertyMap::get).collect(Collectors.toList()));
    }

    @Override
    public T value(T defaultValue) {
        return this.value().orElse(defaultValue);
    }

    private List<ObjectPropertyField> toPropertyFields(Map<String, String> bindingMap, Class<T> cfgClass) {
        ArrayList<ObjectPropertyField> propertyFields = new ArrayList<ObjectPropertyField>(bindingMap.size());
        for (String fieldName : bindingMap.keySet()) {
            Field field;
            try {
                field = cfgClass.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                throw ThrowableUtil.propagate(e);
            }
            int modifiers = field.getModifiers();
            if (Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers)) continue;
            propertyFields.add(new ObjectPropertyField(field, bindingMap.get(fieldName)));
        }
        return propertyFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertyCallback<T> computePropertyCallback(Class<T> cfgClass, List<ObjectPropertyField> propertyFields, Map<String, Map<Class, PropertyCallback>> propertyCallbackMap) {
        PropertyCallback<Object> propertyCallback = new PropertyCallback<Object>(list -> ObjectPropertyParser.parseObject(list, propertyFields, cfgClass));
        List<String> propertyNames = propertyFields.stream().map(ObjectPropertyField::getPropertyName).collect(Collectors.toList());
        Map<String, Map<Class, PropertyCallback>> map = propertyCallbackMap;
        synchronized (map) {
            propertyNames.forEach(propName -> {
                propertyCallbackMap.putIfAbsent((String)propName, new ConcurrentHashMap());
                Map callbackMap = (Map)propertyCallbackMap.get(propName);
                callbackMap.putIfAbsent(this.propertyClass, propertyCallback);
            });
        }
        return (PropertyCallback)propertyCallbackMap.values().stream().filter(callbackMap -> callbackMap.containsKey(this.propertyClass)).map(callbackMap -> (PropertyCallback)callbackMap.get(this.propertyClass)).collect(Collectors.toSet()).iterator().next();
    }
}

