/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.config;

import io.scalecube.config.DurationParser;
import io.scalecube.config.ListConfigPropertyImpl;
import io.scalecube.config.MultimapConfigPropertyImpl;
import io.scalecube.config.utils.ThrowableUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

class ObjectPropertyField {
    private final Field field;
    private final String propertyName;
    private final Function<String, ?> valueParser;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ObjectPropertyField(Field field, String propertyName) {
        int modifiers = field.getModifiers();
        if (Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers)) {
            throw new IllegalArgumentException("ObjectPropertyField: 'static' or 'final' declaration is not supported (field: " + field + ")");
        }
        this.field = field;
        field.setAccessible(true);
        this.propertyName = propertyName;
        if (field.getGenericType() instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)field.getGenericType();
            if (this.isList(paramType)) {
                Type type = paramType.getActualTypeArguments()[0];
                this.valueParser = ListConfigPropertyImpl.toListPropertyParser(this.getValueParser(type));
                return;
            } else {
                if (!this.isMultimap(paramType)) throw new IllegalArgumentException("ObjectPropertyField: unsupported type on field: " + field);
                Type[] typeArguments = paramType.getActualTypeArguments();
                ParameterizedType valueType = (ParameterizedType)typeArguments[1];
                Type type = valueType.getActualTypeArguments()[0];
                this.valueParser = MultimapConfigPropertyImpl.toMultimapPropertyParser(this.getValueParser(type));
            }
            return;
        } else {
            this.valueParser = this.getValueParser(field.getType());
        }
    }

    private boolean isList(ParameterizedType paramType) {
        return paramType.getRawType() == List.class;
    }

    private boolean isMultimap(ParameterizedType paramType) {
        boolean result = false;
        if (paramType.getRawType() == Map.class) {
            ParameterizedType parameterizedValueType;
            Type[] typeArguments = paramType.getActualTypeArguments();
            Type keyType = typeArguments[0];
            Type valueType = typeArguments[1];
            if (keyType == String.class && valueType instanceof ParameterizedType && (parameterizedValueType = (ParameterizedType)valueType).getRawType() == List.class) {
                result = true;
            }
        }
        return result;
    }

    private Function<String, ?> getValueParser(Type type) {
        if (type == String.class) {
            return str -> str;
        }
        if (type == Duration.class) {
            return DurationParser::parseDuration;
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return Integer::parseInt;
        }
        if (type == Double.TYPE || type == Double.class) {
            return Double::parseDouble;
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return Boolean::parseBoolean;
        }
        if (type == Long.TYPE || type == Long.class) {
            return Long::parseLong;
        }
        throw new IllegalArgumentException("ObjectPropertyField: unsupported type on field: " + this.field);
    }

    String getPropertyName() {
        return this.propertyName;
    }

    void applyValueParser(Object instance, String value) {
        try {
            this.field.set(instance, this.valueParser.apply(value));
        }
        catch (IllegalAccessException e) {
            throw ThrowableUtil.propagate(e);
        }
    }
}

