/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.config;

import io.scalecube.config.ObjectPropertyField;
import io.scalecube.config.source.LoadedConfigProperty;
import io.scalecube.config.utils.ThrowableUtil;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

class ObjectPropertyParser {
    private ObjectPropertyParser() {
    }

    static <T> T parseObject(List<LoadedConfigProperty> inputList, List<ObjectPropertyField> propertyFields, Class<T> cfgClass) {
        T instance;
        try {
            instance = cfgClass.newInstance();
        }
        catch (Exception e) {
            throw ThrowableUtil.propagate(e);
        }
        Map<String, Optional> inputMap = inputList.stream().collect(Collectors.toMap(LoadedConfigProperty::name, LoadedConfigProperty::valueAsString));
        for (ObjectPropertyField propertyField : propertyFields) {
            Optional valueOptional = inputMap.get(propertyField.getPropertyName());
            if (valueOptional == null || !valueOptional.isPresent()) continue;
            propertyField.applyValueParser(instance, (String)valueOptional.get());
        }
        return instance;
    }
}

