/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.config;

import io.scalecube.config.AbstractConfigProperty;
import io.scalecube.config.audit.ConfigEvent;
import io.scalecube.config.source.LoadedConfigProperty;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PropertyCallback<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyCallback.class);
    private static final String ERROR_EXCEPTION_ON_VALUE_PARSER = "Exception occurred at valueParser on input: %s, cause: %s";
    private static final String ERROR_EXCEPTION_AT_ACCEPT_VALUE = "Exception occurred at acceptValue on input: %s, on value: %s, cause: %s";
    private final Function<List<LoadedConfigProperty>, T> valueParser;
    private final Collection<AbstractConfigProperty<T>> configProperties = new CopyOnWriteArraySet<AbstractConfigProperty<T>>();

    PropertyCallback(Function<List<LoadedConfigProperty>, T> valueParser) {
        this.valueParser = list -> list == null || list.isEmpty() ? null : valueParser.apply((List<LoadedConfigProperty>)list);
    }

    void addConfigProperty(AbstractConfigProperty<T> configProperty) {
        this.configProperties.add(configProperty);
    }

    void computeValue(List<ConfigEvent> events) {
        Object value;
        List<LoadedConfigProperty> inputList = events.stream().filter(event -> event.getType() != ConfigEvent.Type.REMOVED).map(event -> LoadedConfigProperty.withNameAndValue(event.getName(), event.getNewValue()).source(event.getNewSource()).origin(event.getNewOrigin()).build()).collect(Collectors.toList());
        try {
            value = this.applyValueParser(inputList);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), e.getCause());
            return;
        }
        Object value1 = value;
        this.configProperties.forEach(configProperty -> {
            try {
                configProperty.acceptValue(value1, inputList, true);
            }
            catch (Exception e) {
                LOGGER.error(String.format(ERROR_EXCEPTION_AT_ACCEPT_VALUE, inputList, value1, e));
            }
        });
    }

    void computeValue(List<LoadedConfigProperty> inputList, AbstractConfigProperty<T> configProperty) {
        T value = this.applyValueParser(inputList);
        try {
            configProperty.acceptValue(value, inputList, false);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format(ERROR_EXCEPTION_AT_ACCEPT_VALUE, inputList, value, e));
        }
    }

    private T applyValueParser(List<LoadedConfigProperty> inputList) {
        try {
            return this.valueParser.apply(inputList);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format(ERROR_EXCEPTION_ON_VALUE_PARSER, inputList, e));
        }
    }
}

