/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.config.audit;

import io.scalecube.config.ConfigProperty;
import java.util.Date;
import java.util.Objects;

public final class ConfigEvent {
    private final String name;
    private final Date timestamp;
    private final Type type;
    private final String host;
    private final String oldValue;
    private final String oldSource;
    private final String oldOrigin;
    private final String newValue;
    private final String newSource;
    private final String newOrigin;

    private ConfigEvent(String name, Type type, String host, ConfigProperty oldProp, ConfigProperty newProp) {
        this.name = Objects.requireNonNull(name, "ConfigEvent: propName is required");
        this.timestamp = new Date();
        this.type = type;
        this.host = host;
        this.oldValue = oldProp != null ? (String)oldProp.valueAsString().orElse(null) : null;
        this.oldSource = oldProp != null ? (String)oldProp.source().orElse(null) : null;
        this.oldOrigin = oldProp != null ? (String)oldProp.origin().orElse(null) : null;
        this.newValue = newProp != null ? (String)newProp.valueAsString().orElse(null) : null;
        this.newSource = newProp != null ? (String)newProp.source().orElse(null) : null;
        this.newOrigin = newProp != null ? (String)newProp.origin().orElse(null) : null;
    }

    public static ConfigEvent createAdded(String propName, String host, ConfigProperty newProp) {
        Objects.requireNonNull(newProp, "ConfigEvent: newProp is required");
        return new ConfigEvent(propName, Type.ADDED, host, null, newProp);
    }

    public static ConfigEvent createRemoved(String propName, String host, ConfigProperty oldProp) {
        Objects.requireNonNull(oldProp, "ConfigEvent: oldProp is required");
        return new ConfigEvent(propName, Type.REMOVED, host, oldProp, null);
    }

    public static ConfigEvent createUpdated(String propName, String host, ConfigProperty oldProp, ConfigProperty newProp) {
        Objects.requireNonNull(newProp, "ConfigEvent: newProp is required");
        Objects.requireNonNull(oldProp, "ConfigEvent: oldProp is required");
        return new ConfigEvent(propName, Type.UPDATED, host, oldProp, newProp);
    }

    public String getName() {
        return this.name;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public Type getType() {
        return this.type;
    }

    public String getHost() {
        return this.host;
    }

    public String getOldValue() {
        return this.oldValue;
    }

    public String getOldSource() {
        return this.oldSource;
    }

    public String getOldOrigin() {
        return this.oldOrigin;
    }

    public String getNewValue() {
        return this.newValue;
    }

    public String getNewSource() {
        return this.newSource;
    }

    public String getNewOrigin() {
        return this.newOrigin;
    }

    public boolean isChanged() {
        if (this.type == Type.ADDED || this.type == Type.REMOVED) {
            return true;
        }
        return !Objects.equals(this.oldSource, this.newSource) || !Objects.equals(this.oldOrigin, this.newOrigin) || !Objects.equals(this.oldValue, this.newValue);
    }

    public String toString() {
        return "{\"name\":\" " + this.name + "\",\"timestamp\":\"" + this.timestamp + "\",\"type\":\"" + (Object)((Object)this.type) + "\",\"host\":\"" + this.host + "\",\"oldValue\":\"" + this.oldValue + "\",\"oldSource\":\"" + this.oldSource + "\",\"oldOrigin\":\"" + this.oldOrigin + "\",\"newValue\":\"" + this.newValue + "\",\"newSource\":\"" + this.newSource + "\",\"newOrigin\":\"" + this.newOrigin + "\"}";
    }

    public static enum Type {
        ADDED,
        REMOVED,
        UPDATED;

    }
}

