/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.config.audit;

import io.scalecube.config.audit.ConfigEvent;
import io.scalecube.config.audit.ConfigEventListener;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4JConfigEventListener
implements ConfigEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(Slf4JConfigEventListener.class);

    @Override
    public void onEvents(Collection<ConfigEvent> events) {
        if (!events.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            events.stream().sorted(Comparator.comparing(ConfigEvent::getName)).forEach(event -> {
                sb.append("\n");
                sb.append(event.getName()).append("=");
                sb.append(this.propValueAsString((ConfigEvent)event));
                sb.append(",\t");
                sb.append("source=");
                sb.append(this.sourceAsString((ConfigEvent)event));
                sb.append(",\t");
                sb.append("origin=");
                sb.append(this.originAsString((ConfigEvent)event));
            });
            sb.append("\n").append("]");
            LOGGER.info("Config property changed: {}", (Object)sb);
        }
    }

    private String originAsString(ConfigEvent event) {
        if (Objects.equals(event.getOldOrigin(), event.getNewOrigin())) {
            return event.getNewOrigin();
        }
        return event.getOldOrigin() + "->" + event.getNewOrigin();
    }

    private String sourceAsString(ConfigEvent event) {
        if (Objects.equals(event.getOldSource(), event.getNewSource())) {
            return event.getNewSource();
        }
        return event.getOldSource() + "->" + event.getNewSource();
    }

    private String propValueAsString(ConfigEvent event) {
        if (event.getOldValue() != null && event.getNewValue() != null) {
            return "***->***";
        }
        if (event.getOldValue() != null) {
            return "***->null";
        }
        if (event.getNewValue() != null) {
            return "null->***";
        }
        return null;
    }
}

