/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.config.keyvalue;

import java.util.Objects;
import java.util.Optional;

public final class KeyValueConfigName {
    private final String groupName;
    private final String collectionName;

    public KeyValueConfigName(String groupName, String collectionName) {
        this.groupName = groupName;
        this.collectionName = Objects.requireNonNull(collectionName);
    }

    public String getQualifiedName() {
        return this.groupName != null ? this.groupName + '.' + this.collectionName : this.collectionName;
    }

    public Optional<String> getGroupName() {
        return Optional.ofNullable(this.groupName);
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyValueConfigName that = (KeyValueConfigName)o;
        return Objects.equals(this.groupName, that.groupName) && Objects.equals(this.collectionName, that.collectionName);
    }

    public int hashCode() {
        return Objects.hash(this.groupName, this.collectionName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("KeyValueConfigName{");
        sb.append("groupName='").append(this.groupName).append('\'');
        sb.append(", collectionName='").append(this.collectionName).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

