/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.config.source;

import io.scalecube.config.ConfigProperty;
import io.scalecube.config.source.FilteredPathConfigSource;
import io.scalecube.config.source.LoadedConfigProperty;
import io.scalecube.config.utils.ConfigCollectorUtil;
import io.scalecube.config.utils.ThrowableUtil;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassPathConfigSource
extends FilteredPathConfigSource {
    private final ClassLoader classLoader;
    private Map<String, ConfigProperty> loadedConfig;

    public ClassPathConfigSource(ClassLoader classLoader, List<Predicate<Path>> predicates) {
        super(predicates);
        this.classLoader = Objects.requireNonNull(classLoader, "ClassPathConfigSource: classloader is required");
    }

    public ClassPathConfigSource(List<Predicate<Path>> predicates) {
        this(ClassPathConfigSource.class.getClassLoader(), predicates);
    }

    @SafeVarargs
    public ClassPathConfigSource(ClassLoader classLoader, Predicate<Path> ... predicates) {
        super(Arrays.asList(predicates));
        this.classLoader = classLoader;
    }

    @SafeVarargs
    public ClassPathConfigSource(Predicate<Path> ... predicates) {
        this(ClassPathConfigSource.class.getClassLoader(), Arrays.asList(predicates));
    }

    @Override
    public Map<String, ConfigProperty> loadConfig() {
        if (this.loadedConfig != null) {
            return this.loadedConfig;
        }
        ArrayList<Path> pathCollection = new ArrayList<Path>();
        this.getClassPathEntries(this.classLoader).stream().filter(uri -> uri.getScheme().equals("file")).forEach(uri -> {
            File file = new File((URI)uri);
            if (file.exists()) {
                try {
                    if (file.isDirectory()) {
                        this.scanDirectory(file, "", Collections.emptySet(), pathCollection);
                    } else {
                        this.scanJar(file, pathCollection);
                    }
                }
                catch (Exception e) {
                    throw ThrowableUtil.propagate(e);
                }
            }
        });
        Map<Path, Map<String, String>> configMap = this.loadConfigMap(pathCollection);
        TreeMap<String, ConfigProperty> result = new TreeMap<String, ConfigProperty>();
        ConfigCollectorUtil.filterAndCollectInOrder(this.predicates.iterator(), configMap, (path, map) -> map.entrySet().forEach(entry -> {
            ConfigProperty cfr_ignored_0 = result.putIfAbsent((String)entry.getKey(), LoadedConfigProperty.withNameAndValue(entry).origin(path.toString()).build());
        }));
        this.loadedConfig = result;
        return this.loadedConfig;
    }

    private Collection<URI> getClassPathEntries(ClassLoader classLoader) {
        LinkedHashSet<URI> entries = new LinkedHashSet<URI>();
        ClassLoader parent = classLoader.getParent();
        if (parent != null) {
            entries.addAll(this.getClassPathEntries(parent));
        }
        if (classLoader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
            for (URL entry : urlClassLoader.getURLs()) {
                try {
                    entries.add(entry.toURI());
                }
                catch (URISyntaxException e) {
                    throw ThrowableUtil.propagate(e);
                }
            }
        }
        return new LinkedHashSet<URI>(entries);
    }

    private void scanDirectory(File directory, String prefix, Set<File> ancestors, Collection<Path> collector) throws IOException {
        File canonical = directory.getCanonicalFile();
        if (ancestors.contains(canonical)) {
            return;
        }
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        HashSet<File> objects = new HashSet<File>();
        objects.addAll(ancestors);
        objects.add(canonical);
        Set<File> newAncestors = Collections.unmodifiableSet(objects);
        for (File f : files) {
            String name = f.getName();
            if (f.isDirectory()) {
                this.scanDirectory(f, prefix + name + "/", newAncestors, collector);
                continue;
            }
            collector.add(f.toPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanJar(File file, Collection<Path> collector) throws IOException {
        JarFile jarFile;
        try {
            jarFile = new JarFile(file);
        }
        catch (IOException ignore) {
            return;
        }
        try (FileSystem zipfs = FileSystems.newFileSystem(file.toPath(), null);){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                collector.add(zipfs.getPath(entry.getName(), new String[0]));
            }
        }
        finally {
            try {
                jarFile.close();
            }
            catch (IOException iOException) {}
        }
    }

    public String toString() {
        return "ClassPathConfigSource{classLoader=" + this.classLoader + '}';
    }
}

