/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.config.source;

import io.scalecube.config.source.ConfigSource;
import io.scalecube.config.utils.ThrowableUtil;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FilteredPathConfigSource
implements ConfigSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilteredPathConfigSource.class);
    protected final List<Predicate<Path>> predicates;

    protected FilteredPathConfigSource(List<Predicate<Path>> predicates) {
        Objects.requireNonNull(predicates, "FilteredPathConfigSource: predicates are required");
        this.predicates = Collections.unmodifiableList(predicates);
    }

    protected final Map<Path, Map<String, String>> loadConfigMap(Collection<Path> pathCollection) {
        return pathCollection.stream().filter(path -> this.predicates.stream().anyMatch(predicate -> predicate.test(path))).collect(Collectors.toMap(path -> path, this::loadProperties));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, String> loadProperties(Path input) {
        try (InputStream is = input.toUri().toURL().openStream();){
            Properties properties = new Properties();
            properties.load(is);
            Map<String, String> map = this.fromProperties(properties);
            return map;
        }
        catch (Exception e) {
            LOGGER.error("Exception at loading props from '{}', cause: {}", (Object)input, (Object)e);
            throw ThrowableUtil.propagate(e);
        }
    }

    private Map<String, String> fromProperties(Properties properties) {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            map.put(key, properties.getProperty(key));
        }
        return map;
    }
}

