/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.config.source;

import io.scalecube.config.ConfigProperty;
import java.util.Map;
import java.util.Optional;

public final class LoadedConfigProperty
implements ConfigProperty {
    private final String name;
    private final String source;
    private final String origin;
    private final String value;

    private LoadedConfigProperty(Builder builder) {
        this.name = builder.name;
        this.source = builder.source;
        this.origin = builder.origin;
        this.value = builder.value;
    }

    public static LoadedConfigProperty forNameAndValue(String name, String value) {
        return LoadedConfigProperty.withNameAndValue(name, value).build();
    }

    public static Builder withNameAndValue(Map.Entry<String, String> entry) {
        return LoadedConfigProperty.withNameAndValue(entry.getKey(), entry.getValue());
    }

    public static Builder withNameAndValue(String name, String value) {
        return new Builder(name, value);
    }

    public static Builder withCopyFrom(ConfigProperty property) {
        Builder builder = new Builder(property.name(), property.valueAsString(null));
        builder.source = property.source().orElse(null);
        builder.origin = property.origin().orElse(null);
        return builder;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Optional<String> source() {
        return Optional.ofNullable(this.source);
    }

    @Override
    public Optional<String> origin() {
        return Optional.ofNullable(this.origin);
    }

    @Override
    public Optional<String> valueAsString() {
        return Optional.ofNullable(this.value);
    }

    @Override
    public String valueAsString(String defaultValue) {
        return this.valueAsString().orElse(defaultValue);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("LoadedConfigProperty{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", source='").append(this.source).append('\'');
        sb.append(", origin='").append(this.origin).append('\'');
        sb.append(", value='").append(this.value).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public static class Builder {
        private final String name;
        private final String value;
        private String source;
        private String origin;

        public Builder(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public Builder source(String source) {
            this.source = source;
            return this;
        }

        public Builder origin(String origin) {
            this.origin = origin;
            return this;
        }

        public LoadedConfigProperty build() {
            return new LoadedConfigProperty(this);
        }
    }
}

