/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.config.source;

import io.scalecube.config.ConfigProperty;
import io.scalecube.config.source.ConfigSource;
import io.scalecube.config.source.LoadedConfigProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Stream;

public class SystemEnvironmentConfigSource
implements ConfigSource {
    private final List<String> namespaces;
    private Map<String, ConfigProperty> loadedConfig;

    public SystemEnvironmentConfigSource() {
        this.namespaces = Collections.emptyList();
    }

    public SystemEnvironmentConfigSource(List<String> namespaces) {
        this.namespaces = new ArrayList<String>(namespaces);
    }

    public SystemEnvironmentConfigSource(String ... namespaces) {
        this.namespaces = Arrays.asList(namespaces);
    }

    @Override
    public Map<String, ConfigProperty> loadConfig() {
        if (this.loadedConfig != null) {
            return this.loadedConfig;
        }
        Map<String, String> env = System.getenv();
        TreeMap<String, ConfigProperty> result = new TreeMap<String, ConfigProperty>();
        Stream namespaces1 = this.namespaces.stream();
        for (Map.Entry<String, String> entry : env.entrySet()) {
            String propName = entry.getKey();
            if (!this.namespaces.isEmpty()) {
                if (!namespaces1.anyMatch(propName::startsWith)) continue;
            }
            result.put(propName, LoadedConfigProperty.forNameAndValue(propName, entry.getValue()));
        }
        this.loadedConfig = result;
        return this.loadedConfig;
    }
}

