/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.config.source;

import io.scalecube.config.ConfigProperty;
import io.scalecube.config.source.ConfigSource;
import io.scalecube.config.source.LoadedConfigProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.stream.Stream;

public class SystemPropertiesConfigSource
implements ConfigSource {
    private final List<String> namespaces;
    private Map<String, ConfigProperty> loadedConfig;

    public SystemPropertiesConfigSource() {
        this.namespaces = Collections.emptyList();
    }

    public SystemPropertiesConfigSource(List<String> namespaces) {
        this.namespaces = new ArrayList<String>(namespaces);
    }

    public SystemPropertiesConfigSource(String ... namespaces) {
        this.namespaces = Arrays.asList(namespaces);
    }

    @Override
    public Map<String, ConfigProperty> loadConfig() {
        if (this.loadedConfig != null) {
            return this.loadedConfig;
        }
        Properties properties = System.getProperties();
        TreeMap<String, ConfigProperty> result = new TreeMap<String, ConfigProperty>();
        Stream namespaces1 = this.namespaces.stream();
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String propName = (String)e.nextElement();
            if (!this.namespaces.isEmpty()) {
                if (!namespaces1.anyMatch(propName::startsWith)) continue;
            }
            result.put(propName, LoadedConfigProperty.forNameAndValue(propName, properties.getProperty(propName)));
        }
        this.loadedConfig = result;
        return this.loadedConfig;
    }
}

