/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.config.utils;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class ConfigCollectorUtil {
    private ConfigCollectorUtil() {
    }

    public static <T> void filterAndCollectInOrder(Iterator<Predicate<T>> predicateIterator, Map<T, Map<String, String>> configMap, BiConsumer<T, Map<String, String>> configCollector) {
        if (!predicateIterator.hasNext()) {
            return;
        }
        Predicate<T> groupPredicate = predicateIterator.next();
        List groups = configMap.keySet().stream().filter(groupPredicate).collect(Collectors.toList());
        for (Object group : groups) {
            Map<String, String> map = configMap.get(group);
            if (map.isEmpty()) continue;
            configCollector.accept(group, map);
        }
        ConfigCollectorUtil.filterAndCollectInOrder(predicateIterator, configMap, configCollector);
    }
}

