/*
 * Decompiled with CFR 0.152.
 */
package reactor.aeron;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.Charset;
import org.agrona.DirectBuffer;
import reactor.aeron.AeronDuplex;
import reactor.aeron.mdc.AeronClient;
import reactor.aeron.mdc.AeronResources;
import reactor.core.CoreSubscriber;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxOperator;

public class ClientServerSends {
    public static void main(String[] args) {
        AeronResources resources = (AeronResources)new AeronResources().useTmpDir().start().block();
        ((AeronDuplex)AeronClient.create((AeronResources)resources).options("localhost", 13000, 13001).handle(connection -> ((ByteBufFlux)((Object)((Object)connection.inbound().receive().as(ByteBufFlux::create)))).asString().log("receive").then(connection.onDispose())).connect().block()).onDispose((Disposable)resources).onDispose().block();
    }

    static class ByteBufFlux
    extends FluxOperator<ByteBuf, ByteBuf> {
        public ByteBufFlux(Flux<? extends ByteBuf> source) {
            super(source);
        }

        public static ByteBufFlux create(Flux<DirectBuffer> directBufferFlux) {
            return new ByteBufFlux((Flux<? extends ByteBuf>)directBufferFlux.map(buffer -> {
                byte[] bytes = new byte[buffer.capacity()];
                buffer.getBytes(0, bytes);
                return Unpooled.copiedBuffer((byte[])bytes);
            }));
        }

        public void subscribe(CoreSubscriber<? super ByteBuf> actual) {
            this.source.subscribe(actual);
        }

        public Flux<String> asString() {
            return this.map(buffer -> buffer.toString(Charset.defaultCharset()));
        }
    }
}

