/*
 * Decompiled with CFR 0.152.
 */
package reactor.aeron;

import io.aeron.Image;
import io.aeron.Subscription;
import org.agrona.concurrent.BackoffIdleStrategy;
import org.agrona.concurrent.BusySpinIdleStrategy;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.NoOpIdleStrategy;
import org.agrona.concurrent.SleepingIdleStrategy;
import org.agrona.concurrent.SleepingMillisIdleStrategy;
import org.agrona.concurrent.YieldingIdleStrategy;

public interface Configurations {
    public static final int FRAGMENT_COUNT_LIMIT = Integer.getInteger("reactor.aeron.sample.frameCountLimit", 10);
    public static final int MESSAGE_LENGTH = Integer.getInteger("reactor.aeron.sample.messageLength", 128);
    public static final int REQUESTED = Integer.getInteger("reactor.aeron.sample.request", 16);
    public static final int WARMUP_NUMBER_OF_ITERATIONS = Integer.getInteger("reactor.aeron.sample.warmup.iterations", 5);
    public static final long WARMUP_NUMBER_OF_MESSAGES = Long.getLong("reactor.aeron.sample.warmup.messages", 10000L);
    public static final long NUMBER_OF_MESSAGES = Long.getLong("reactor.aeron.sample.messages", 100000000L);
    public static final boolean EXCLUSIVE_PUBLICATIONS = Boolean.getBoolean("reactor.aeron.sample.exclusive.publications");
    public static final boolean EMBEDDED_MEDIA_DRIVER = Boolean.getBoolean("reactor.aeron.sample.embeddedMediaDriver");
    public static final boolean INFO_FLAG = Boolean.getBoolean("reactor.aeron.sample.info");
    public static final int PING_STREAM_ID = Integer.getInteger("reactor.aeron.sample.ping.streamId", 10);
    public static final int PONG_STREAM_ID = Integer.getInteger("reactor.aeron.sample.pong.streamId", 10);
    public static final String PING_CHANNEL = System.getProperty("reactor.aeron.sample.ping.channel", "aeron:udp?endpoint=localhost:40123");
    public static final String PONG_CHANNEL = System.getProperty("reactor.aeron.sample.pong.channel", "aeron:udp?endpoint=localhost:40124");
    public static final String MDC_ADDRESS = System.getProperty("reactor.aeron.sample.mdc.address", "localhost");
    public static final int MDC_PORT = Integer.getInteger("reactor.aeron.sample.mdc.port", 13000);
    public static final int MDC_CONTROL_PORT = Integer.getInteger("reactor.aeron.sample.mdc.control.port", 13001);
    public static final int MDC_STREAM_ID = Integer.getInteger("reactor.aeron.sample.mdc.stream.id", -889323520);
    public static final int MDC_SESSION_ID = Integer.getInteger("reactor.aeron.sample.mdc.session.id", 1001);
    public static final String IDLE_STRATEGY = System.getProperty("reactor.aeron.sample.idle.strategy", "busyspin");
    public static final long REPORT_INTERVAL = Long.getLong("reactor.aeron.sample.report.interval", 1L);
    public static final long TRACE_REPORTER_INTERVAL = Long.getLong("reactor.aeron.sample.report.interval", 60L);
    public static final long WARMUP_REPORT_DELAY = Long.getLong("reactor.aeron.sample.report.delay", REPORT_INTERVAL);
    public static final String TARGET_FOLDER_FOLDER_LATENCY = System.getProperty("reactor.aeron.report.traces.folder.latency", "./target/traces/reports/latency/");
    public static final String TARGET_FOLDER_FOLDER_THROUGHPUT = System.getProperty("reactor.aeron.report.traces.folder.throughput", "./target/traces/reports/throughput/");
    public static final String REPORT_NAME = System.getProperty("reactor.aeron.report.name", String.valueOf(System.nanoTime()));

    public static IdleStrategy idleStrategy() {
        String[] chunks = IDLE_STRATEGY.split("/");
        switch (chunks[0].toLowerCase()) {
            case "backoff": {
                return new BackoffIdleStrategy(Long.parseLong(chunks[1]), Long.parseLong(chunks[2]), Long.parseLong(chunks[3]), Long.parseLong(chunks[4]));
            }
            case "busyspin": {
                return new BusySpinIdleStrategy();
            }
            case "sleeping": {
                return new SleepingIdleStrategy(Long.parseLong(chunks[1]));
            }
            case "sleepingmillis": {
                return new SleepingMillisIdleStrategy(Long.parseLong(chunks[1]));
            }
            case "yielding": {
                return new YieldingIdleStrategy();
            }
            case "noop": {
                return new NoOpIdleStrategy();
            }
        }
        return new BusySpinIdleStrategy();
    }

    public static void printAvailableImage(Image image) {
        Subscription subscription = image.subscription();
        System.out.println(String.format("Available image on %s streamId=%d sessionId=%d from %s", subscription.channel(), subscription.streamId(), image.sessionId(), image.sourceIdentity()));
    }

    public static void printUnavailableImage(Image image) {
        Subscription subscription = image.subscription();
        System.out.println(String.format("Unavailable image on %s streamId=%d sessionId=%d", subscription.channel(), subscription.streamId(), image.sessionId()));
    }
}

