/*
 * Decompiled with CFR 0.152.
 */
package reactor.aeron;

import io.scalecube.trace.TraceReporter;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import reactor.aeron.Configurations;
import reactor.core.Disposable;
import reactor.core.scheduler.Schedulers;

public class RateReporter
implements Runnable,
Disposable {
    private final long reportIntervalNs;
    private final Reporter reporter;
    private final Disposable disposable;
    private final LongAdder totalBytes = new LongAdder();
    private final LongAdder totalMessages = new LongAdder();
    private long lastTotalBytes;
    private long lastTotalMessages;
    private long lastTimestamp;
    private String name;
    private static final TraceReporter traceReporter = new TraceReporter();

    public RateReporter() {
        this(Configurations.REPORT_NAME);
    }

    public RateReporter(String name) {
        this(name, Configurations.TARGET_FOLDER_FOLDER_THROUGHPUT);
    }

    public RateReporter(String name, String location) {
        this(RateReporter::printRate, name, location);
    }

    private RateReporter(Reporter reporter, String name, String location) {
        this.name = name;
        long reportDelayNs = Duration.ofSeconds(Configurations.WARMUP_REPORT_DELAY).toNanos();
        this.reportIntervalNs = Duration.ofSeconds(Configurations.REPORT_INTERVAL).toNanos();
        this.reporter = reporter;
        this.disposable = Schedulers.single().schedulePeriodically((Runnable)this, reportDelayNs, this.reportIntervalNs, TimeUnit.NANOSECONDS);
        if (traceReporter.isActive()) {
            traceReporter.scheduleDumpTo(Duration.ofSeconds(Configurations.TRACE_REPORTER_INTERVAL), location);
        }
    }

    @Override
    public void run() {
        long currentTotalMessages = this.totalMessages.longValue();
        long currentTotalBytes = this.totalBytes.longValue();
        long currentTimestamp = System.nanoTime();
        long timeSpanNs = currentTimestamp - this.lastTimestamp;
        double messagesPerSec = (double)(currentTotalMessages - this.lastTotalMessages) * (double)this.reportIntervalNs / (double)timeSpanNs;
        double bytesPerSec = (double)(currentTotalBytes - this.lastTotalBytes) * (double)this.reportIntervalNs / (double)timeSpanNs;
        if (traceReporter.isActive()) {
            traceReporter.addY(this.name, (Object)messagesPerSec);
        }
        this.reporter.onReport(messagesPerSec, bytesPerSec, currentTotalMessages, currentTotalBytes);
        this.lastTotalBytes = currentTotalBytes;
        this.lastTotalMessages = currentTotalMessages;
        this.lastTimestamp = currentTimestamp;
    }

    public void dispose() {
        this.disposable.dispose();
    }

    public boolean isDisposed() {
        return this.disposable.isDisposed();
    }

    public void onMessage(long messages, long bytes) {
        this.totalBytes.add(bytes);
        this.totalMessages.add(messages);
    }

    private static void printRate(double messagesPerSec, double bytesPerSec, long totalFragments, long totalBytes) {
        System.out.format("%.07g msgs/sec, %.07g MB/sec, totals %d messages %d MB payloads%n", messagesPerSec, bytesPerSec / 1048576.0, totalFragments, totalBytes / 0x100000L);
    }

    @FunctionalInterface
    public static interface Reporter {
        public void onReport(double var1, double var3, long var5, long var7);
    }
}

