/*
 * Decompiled with CFR 0.152.
 */
package reactor.aeron;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.Charset;
import java.time.Duration;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.reactivestreams.Publisher;
import reactor.aeron.DirectBufferHandler;
import reactor.aeron.OnDisposable;
import reactor.aeron.mdc.AeronResources;
import reactor.aeron.mdc.AeronServer;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;

public class ServerServerSends {
    public static void main(String[] args) {
        AeronResources resources = (AeronResources)new AeronResources().useTmpDir().start().block();
        ((OnDisposable)AeronServer.create((AeronResources)resources).options("localhost", 13000, 13001).handle(connection -> connection.outbound().send((Publisher)Flux.range((int)1, (int)10000).delayElements(Duration.ofMillis(250L)).map(String::valueOf).log("send").map(s -> Unpooled.copiedBuffer((CharSequence)s, (Charset)Charset.defaultCharset())), (DirectBufferHandler)ByteBufHandler.defaultInstance).then((Publisher)connection.onDispose())).bind().block()).onDispose((Disposable)resources).onDispose().block();
    }

    static class ByteBufHandler
    implements DirectBufferHandler<ByteBuf> {
        static final ByteBufHandler defaultInstance = new ByteBufHandler();

        ByteBufHandler() {
        }

        public DirectBuffer map(ByteBuf buffer) {
            return new UnsafeBuffer(buffer.nioBuffer(), 0, buffer.readableBytes());
        }

        public void dispose(ByteBuf buffer) {
            buffer.release();
        }
    }
}

