/*
 * Decompiled with CFR 0.152.
 */
package reactor.aeron;

import reactor.aeron.Configurations;
import reactor.aeron.OnDisposable;
import reactor.aeron.RateReporter;
import reactor.aeron.mdc.AeronResources;
import reactor.aeron.mdc.AeronServer;
import reactor.core.Disposable;

public class ServerThroughput {
    public static void main(String[] args) {
        ServerThroughput.printSettings();
        AeronResources aeronResources = (AeronResources)new AeronResources().useTmpDir().pollFragmentLimit(Configurations.FRAGMENT_COUNT_LIMIT).singleWorker().workerIdleStrategySupplier(Configurations::idleStrategy).start().block();
        RateReporter reporter = new RateReporter();
        ((OnDisposable)AeronServer.create((AeronResources)aeronResources).options(Configurations.MDC_ADDRESS, Configurations.MDC_PORT, Configurations.MDC_CONTROL_PORT).handle(connection -> connection.inbound().receive().doOnNext(buffer -> reporter.onMessage(1L, buffer.capacity())).then(connection.onDispose())).bind().block()).onDispose((Disposable)reporter).onDispose((Disposable)aeronResources).onDispose().block();
    }

    private static void printSettings() {
        System.out.println("address: " + Configurations.MDC_ADDRESS + ", port: " + Configurations.MDC_PORT + ", controlPort: " + Configurations.MDC_CONTROL_PORT);
        System.out.println("pollFragmentLimit of " + Configurations.FRAGMENT_COUNT_LIMIT);
        System.out.println("Using worker idle strategy " + Configurations.idleStrategy().getClass() + "(" + Configurations.IDLE_STRATEGY + ")");
    }
}

