/*
 * Decompiled with CFR 0.152.
 */
package reactor.aeron.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import java.time.Duration;
import java.util.Random;
import org.reactivestreams.Publisher;
import reactor.aeron.Configurations;
import reactor.core.publisher.Flux;
import reactor.netty.channel.BootstrapHandlers;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.resources.LoopResources;
import reactor.netty.tcp.TcpClient;

public class ReactorNettyClientTps {
    private static final ByteBuf PAYLOAD = ByteBufAllocator.DEFAULT.buffer(Configurations.MESSAGE_LENGTH);

    public static void main(String[] args) {
        System.out.println("message size: " + Configurations.MESSAGE_LENGTH + ", number of messages: " + Configurations.NUMBER_OF_MESSAGES + ", address: " + Configurations.MDC_ADDRESS + ", port: " + Configurations.MDC_PORT);
        LoopResources loopResources = LoopResources.create((String)"reactor-netty");
        TcpClient.create((ConnectionProvider)ConnectionProvider.newConnection()).runOn(loopResources).host(Configurations.MDC_ADDRESS).port(Configurations.MDC_PORT).option(ChannelOption.TCP_NODELAY, (Object)true).option(ChannelOption.SO_KEEPALIVE, (Object)true).option(ChannelOption.SO_REUSEADDR, (Object)true).doOnConnected(System.out::println).bootstrap(b -> BootstrapHandlers.updateConfiguration((Bootstrap)b, (String)"channel", (connectionObserver, channel) -> ReactorNettyClientTps.setupChannel(channel))).handle((inbound, outbound) -> {
            int msgNum = (int)Configurations.NUMBER_OF_MESSAGES;
            System.out.println("streaming " + msgNum + " messages ...");
            return outbound.send((Publisher)Flux.range((int)0, (int)msgNum).map(i -> PAYLOAD.retainedSlice())).then();
        }).connectNow().onDispose().doFinally(s -> loopResources.dispose()).block(Duration.ofSeconds(120L));
    }

    private static void setupChannel(Channel channel) {
        int maxFrameLength = 0x100000;
        int lengthFieldLength = 2;
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.addLast(new ChannelHandler[]{new LengthFieldPrepender(2)});
        pipeline.addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(0x100000, 0, 2, 0, 2)});
    }

    static {
        Random random = new Random(System.nanoTime());
        byte[] bytes = new byte[Configurations.MESSAGE_LENGTH];
        random.nextBytes(bytes);
        PAYLOAD.writeBytes(bytes);
    }
}

