/*
 * Decompiled with CFR 0.152.
 */
package reactor.aeron.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import reactor.aeron.Configurations;
import reactor.aeron.RateReporter;
import reactor.core.Disposable;
import reactor.netty.DisposableServer;
import reactor.netty.channel.BootstrapHandlers;
import reactor.netty.resources.LoopResources;
import reactor.netty.tcp.TcpServer;

public class ReactorNettyServerTps {
    public static void main(String[] args) throws InterruptedException {
        System.out.println("message size: " + Configurations.MESSAGE_LENGTH + ", number of messages: " + Configurations.NUMBER_OF_MESSAGES + ", address: " + Configurations.MDC_ADDRESS + ", port: " + Configurations.MDC_PORT);
        LoopResources loopResources = LoopResources.create((String)"reactor-netty");
        RateReporter reporter = new RateReporter();
        ((DisposableServer)TcpServer.create().runOn(loopResources).host(Configurations.MDC_ADDRESS).port(Configurations.MDC_PORT).option(ChannelOption.TCP_NODELAY, (Object)true).option(ChannelOption.SO_KEEPALIVE, (Object)true).option(ChannelOption.SO_REUSEADDR, (Object)true).doOnConnection(System.out::println).bootstrap(b -> BootstrapHandlers.updateConfiguration((ServerBootstrap)b, (String)"channel", (connectionObserver, channel) -> ReactorNettyServerTps.setupChannel(channel))).handle((inbound, outbound) -> inbound.receive().retain().doOnNext(buffer -> {
            reporter.onMessage(1L, buffer.readableBytes());
            buffer.release();
        }).then()).bind().doOnSuccess(server -> System.out.println("server has been started successfully on " + server.address())).block()).onDispose((Disposable)loopResources).onDispose((Disposable)reporter).onDispose().block();
    }

    private static void setupChannel(Channel channel) {
        int maxFrameLength = 0x100000;
        int lengthFieldLength = 2;
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.addLast(new ChannelHandler[]{new LengthFieldPrepender(2)});
        pipeline.addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(0x100000, 0, 2, 0, 2)});
    }
}

