/*
 * Decompiled with CFR 0.152.
 */
package reactor.aeron.pure;

import io.aeron.Aeron;
import io.aeron.ExclusivePublication;
import io.aeron.FragmentAssembler;
import io.aeron.Image;
import io.aeron.Publication;
import io.aeron.Subscription;
import io.aeron.driver.MediaDriver;
import io.aeron.logbuffer.FragmentHandler;
import io.aeron.logbuffer.Header;
import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.HdrHistogram.Recorder;
import org.agrona.BufferUtil;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.console.ContinueBarrier;
import reactor.aeron.Configurations;
import reactor.aeron.LatencyReporter;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;

public class Ping {
    private static final int PING_STREAM_ID = Configurations.PING_STREAM_ID;
    private static final int PONG_STREAM_ID = Configurations.PONG_STREAM_ID;
    private static final long NUMBER_OF_MESSAGES = Configurations.NUMBER_OF_MESSAGES;
    private static final long WARMUP_NUMBER_OF_MESSAGES = Configurations.WARMUP_NUMBER_OF_MESSAGES;
    private static final int WARMUP_NUMBER_OF_ITERATIONS = Configurations.WARMUP_NUMBER_OF_ITERATIONS;
    private static final int MESSAGE_LENGTH = Configurations.MESSAGE_LENGTH;
    private static final int FRAGMENT_COUNT_LIMIT = Configurations.FRAGMENT_COUNT_LIMIT;
    private static final boolean EMBEDDED_MEDIA_DRIVER = Configurations.EMBEDDED_MEDIA_DRIVER;
    private static final String PING_CHANNEL = Configurations.PING_CHANNEL;
    private static final String PONG_CHANNEL = Configurations.PONG_CHANNEL;
    private static final boolean EXCLUSIVE_PUBLICATIONS = Configurations.EXCLUSIVE_PUBLICATIONS;
    private static final UnsafeBuffer OFFER_BUFFER = new UnsafeBuffer(BufferUtil.allocateDirectAligned((int)MESSAGE_LENGTH, (int)64));
    private static final Recorder HISTOGRAM = new Recorder(TimeUnit.SECONDS.toNanos(10L), 3);
    private static final LatencyReporter latencyReporter = new LatencyReporter(HISTOGRAM);
    private static final CountDownLatch LATCH = new CountDownLatch(1);
    private static final IdleStrategy POLLING_IDLE_STRATEGY = Configurations.idleStrategy();

    public static void main(String[] args) throws Exception {
        MediaDriver driver = EMBEDDED_MEDIA_DRIVER ? MediaDriver.launchEmbedded() : null;
        Aeron.Context ctx = new Aeron.Context().availableImageHandler(Ping::availablePongImageHandler);
        FragmentAssembler fragmentHandler = new FragmentAssembler(Ping::pongHandler);
        if (EMBEDDED_MEDIA_DRIVER) {
            ctx.aeronDirectoryName(driver.aeronDirectoryName());
        }
        System.out.println("Publishing Ping at " + PING_CHANNEL + " on stream Id " + PING_STREAM_ID);
        System.out.println("Subscribing Pong at " + PONG_CHANNEL + " on stream Id " + PONG_STREAM_ID);
        System.out.println("Message length of " + MESSAGE_LENGTH + " bytes");
        System.out.println("Using exclusive publications " + EXCLUSIVE_PUBLICATIONS);
        System.out.println("Using poling idle strategy " + POLLING_IDLE_STRATEGY.getClass() + "(" + Configurations.IDLE_STRATEGY + ")");
        try (Aeron aeron = Aeron.connect((Aeron.Context)ctx);
             Subscription subscription = aeron.addSubscription(PONG_CHANNEL, PONG_STREAM_ID);
             ExclusivePublication publication = EXCLUSIVE_PUBLICATIONS ? aeron.addExclusivePublication(PING_CHANNEL, PING_STREAM_ID) : aeron.addPublication(PING_CHANNEL, PING_STREAM_ID);){
            System.out.println("Waiting for new image from Pong...");
            LATCH.await();
            System.out.println("Warming up... " + WARMUP_NUMBER_OF_ITERATIONS + " iterations of " + WARMUP_NUMBER_OF_MESSAGES + " messages");
            for (int i = 0; i < WARMUP_NUMBER_OF_ITERATIONS; ++i) {
                Ping.roundTripMessages((FragmentHandler)fragmentHandler, (Publication)publication, subscription, WARMUP_NUMBER_OF_MESSAGES, true);
            }
            Thread.sleep(100L);
            ContinueBarrier barrier = new ContinueBarrier("Execute again?");
            do {
                System.out.println("Pinging " + NUMBER_OF_MESSAGES + " messages");
                Ping.roundTripMessages((FragmentHandler)fragmentHandler, (Publication)publication, subscription, NUMBER_OF_MESSAGES, false);
                System.out.println("Histogram of RTT latencies in microseconds.");
            } while (barrier.await());
        }
        CloseHelper.quietClose((AutoCloseable)driver);
    }

    private static void roundTripMessages(FragmentHandler fragmentHandler, Publication publication, Subscription subscription, long count, boolean warmup) {
        while (!subscription.isConnected()) {
            Thread.yield();
        }
        HISTOGRAM.reset();
        Disposable reporter = latencyReporter.start();
        Image image = subscription.imageAtIndex(0);
        block1: for (long i = 0L; i < count; ++i) {
            long offeredPosition;
            do {
                OFFER_BUFFER.putLong(0, System.nanoTime());
            } while ((offeredPosition = publication.offer((DirectBuffer)OFFER_BUFFER, 0, MESSAGE_LENGTH)) < 0L);
            POLLING_IDLE_STRATEGY.reset();
            while (true) {
                if (image.poll(fragmentHandler, FRAGMENT_COUNT_LIMIT) <= 0) {
                    POLLING_IDLE_STRATEGY.idle();
                    continue;
                }
                if (image.position() >= offeredPosition) continue block1;
            }
        }
        Mono.delay((Duration)Duration.ofMillis(100L)).doOnSubscribe(s -> reporter.dispose()).then().subscribe();
    }

    private static void pongHandler(DirectBuffer buffer, int offset, int length, Header header) {
        long pingTimestamp = buffer.getLong(offset);
        long rttNs = System.nanoTime() - pingTimestamp;
        HISTOGRAM.recordValue(rttNs);
    }

    private static void availablePongImageHandler(Image image) {
        Subscription subscription = image.subscription();
        System.out.format("Available image: channel=%s streamId=%d session=%d%n", subscription.channel(), subscription.streamId(), image.sessionId());
        if (PONG_STREAM_ID == subscription.streamId() && PONG_CHANNEL.equals(subscription.channel())) {
            LATCH.countDown();
        }
    }
}

