/*
 * Decompiled with CFR 0.152.
 */
package reactor.aeron.rsocket.aeron;

import io.rsocket.Payload;
import io.rsocket.util.ByteBufPayload;
import reactor.aeron.Configurations;
import reactor.aeron.RateReporter;
import reactor.aeron.mdc.AeronResources;

public final class RSocketAeronClientTps {
    public static void main(String ... args) {
        RSocketAeronClientTps.printSettings();
        AeronResources resources = (AeronResources)new AeronResources().useTmpDir().pollFragmentLimit(Configurations.FRAGMENT_COUNT_LIMIT).singleWorker().workerIdleStrategySupplier(Configurations::idleStrategy).start().block();
        Object client = null;
        RateReporter reporter = new RateReporter();
        Payload request = ByteBufPayload.create((String)"hello");
        client.requestStream(request).doOnNext(payload -> {
            reporter.onMessage(1L, payload.sliceData().readableBytes());
            payload.release();
        }).doOnError(Throwable::printStackTrace).doFinally(s -> reporter.dispose()).then().block();
    }

    private static void printSettings() {
        System.out.println("address: " + Configurations.MDC_ADDRESS + ", port: " + Configurations.MDC_PORT + ", controlPort: " + Configurations.MDC_CONTROL_PORT);
        System.out.println("pollFragmentLimit of " + Configurations.FRAGMENT_COUNT_LIMIT);
        System.out.println("Using worker idle strategy " + Configurations.idleStrategy().getClass() + "(" + Configurations.IDLE_STRATEGY + ")");
    }
}

