/*
 * Decompiled with CFR 0.152.
 */
package reactor.aeron.rsocket.aeron;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.ReferenceCounted;
import io.rsocket.Payload;
import io.rsocket.RSocket;
import io.rsocket.util.ByteBufPayload;
import java.util.concurrent.TimeUnit;
import org.HdrHistogram.Recorder;
import reactor.aeron.Configurations;
import reactor.aeron.LatencyReporter;
import reactor.aeron.mdc.AeronResources;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;

public final class RSocketAeronPing {
    private static final Recorder HISTOGRAM = new Recorder(TimeUnit.SECONDS.toNanos(10L), 3);
    private static final LatencyReporter latencyReporter = new LatencyReporter(HISTOGRAM);
    private static final Payload PAYLOAD = ByteBufPayload.create((ByteBuf)ByteBufAllocator.DEFAULT.buffer(Configurations.MESSAGE_LENGTH));

    public static void main(String ... args) {
        RSocketAeronPing.printSettings();
        AeronResources resources = (AeronResources)new AeronResources().useTmpDir().pollFragmentLimit(Configurations.FRAGMENT_COUNT_LIMIT).singleWorker().workerIdleStrategySupplier(Configurations::idleStrategy).start().block();
        RSocket client = null;
        Disposable report = latencyReporter.start();
        Flux.range((int)1, (int)((int)Configurations.NUMBER_OF_MESSAGES)).flatMap(i -> {
            long start = System.nanoTime();
            return client.requestResponse(PAYLOAD.retain()).doOnNext(ReferenceCounted::release).doFinally(signalType -> {
                long diff = System.nanoTime() - start;
                HISTOGRAM.recordValue(diff);
            });
        }, 64).doOnError(Throwable::printStackTrace).doOnTerminate(() -> System.out.println("Sent " + Configurations.NUMBER_OF_MESSAGES + " messages.")).doFinally(s -> report.dispose()).then().doFinally(s -> resources.dispose()).then(resources.onDispose()).block();
    }

    private static void printSettings() {
        System.out.println("address: " + Configurations.MDC_ADDRESS + ", port: " + Configurations.MDC_PORT + ", controlPort: " + Configurations.MDC_CONTROL_PORT);
        System.out.println("Message length of " + Configurations.MESSAGE_LENGTH + " bytes");
        System.out.println("pollFragmentLimit of " + Configurations.FRAGMENT_COUNT_LIMIT);
        System.out.println("Using worker idle strategy " + Configurations.idleStrategy().getClass() + "(" + Configurations.IDLE_STRATEGY + ")");
    }
}

