/*
 * Decompiled with CFR 0.152.
 */
package reactor.aeron.rsocket.aeron;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.util.Random;
import reactor.aeron.Configurations;
import reactor.aeron.mdc.AeronResources;

public final class RSocketAeronServerTps {
    private static final ByteBuf BUFFER = ByteBufAllocator.DEFAULT.buffer(Configurations.MESSAGE_LENGTH);

    public static void main(String ... args) {
        RSocketAeronServerTps.printSettings();
        AeronResources resources = (AeronResources)new AeronResources().useTmpDir().pollFragmentLimit(Configurations.FRAGMENT_COUNT_LIMIT).singleWorker().workerIdleStrategySupplier(Configurations::idleStrategy).start().block();
    }

    private static void printSettings() {
        System.out.println("address: " + Configurations.MDC_ADDRESS + ", port: " + Configurations.MDC_PORT + ", controlPort: " + Configurations.MDC_CONTROL_PORT);
        System.out.println("Message length of " + Configurations.MESSAGE_LENGTH + " bytes");
        System.out.println("pollFragmentLimit of " + Configurations.FRAGMENT_COUNT_LIMIT);
        System.out.println("Using worker idle strategy " + Configurations.idleStrategy().getClass() + "(" + Configurations.IDLE_STRATEGY + ")");
    }

    static {
        Random random = new Random(System.nanoTime());
        byte[] bytes = new byte[Configurations.MESSAGE_LENGTH];
        random.nextBytes(bytes);
        BUFFER.writeBytes(bytes);
    }
}

