/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.benchmarks;

import io.scalecube.benchmarks.BenchmarkSettings;
import io.scalecube.benchmarks.BenchmarkTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;

public class BenchmarkTaskImpl
implements BenchmarkTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(BenchmarkTaskImpl.class);
    private final BiFunction<Long, BenchmarkTask, Publisher<?>> unitOfWork;
    private final Supplier<Mono<Void>> cleanUp;
    private final Scheduler scheduler;
    private final BenchmarkSettings settings;
    private final AtomicLong iterationsCounter = new AtomicLong();
    private final AtomicReference<Status> taskStatus = new AtomicReference();
    private final CompletableFuture<Void> taskCompletionFuture = new CompletableFuture();
    private final AtomicReference<Disposable> scheduledCompletingTask = new AtomicReference();

    public BenchmarkTaskImpl(BenchmarkSettings settings, Scheduler scheduler, BiFunction<Long, BenchmarkTask, Publisher<?>> unitOfWork, Supplier<Mono<Void>> cleanUp) {
        this.settings = settings;
        this.unitOfWork = unitOfWork;
        this.cleanUp = cleanUp;
        this.scheduler = scheduler;
    }

    @Override
    public BenchmarkSettings settings() {
        return this.settings;
    }

    @Override
    public Scheduler scheduler() {
        return this.scheduler;
    }

    @Override
    public void run() {
        if (this.isCompleted()) {
            return;
        }
        if (this.iterationsCounter.get() >= this.settings.numOfIterations()) {
            LOGGER.debug("Task is completed due to iterations limit: " + this.settings.numOfIterations());
            this.startCompleting();
            return;
        }
        if (this.isScheduled()) {
            long iter = this.iterationsCounter.incrementAndGet();
            Publisher<?> publisher = this.unitOfWork.apply(iter, this);
            if (publisher instanceof Mono) {
                ((Mono)publisher).subscribe();
            } else if (publisher instanceof Flux) {
                ((Flux)publisher).subscribe();
            }
            return;
        }
        if (this.setScheduled()) {
            this.scheduledCompletingTask.set(this.scheduler.schedule(() -> {
                LOGGER.debug("Task is completing due to execution duration limit: " + this.settings.executionTaskDuration().toMillis());
                this.startCompleting();
            }, this.settings.executionTaskDuration().toMillis(), TimeUnit.MILLISECONDS));
            LOGGER.debug("Obtained setUp result, now scheduling");
            this.scheduler.schedule((Runnable)this);
        }
    }

    public Mono<Void> completionMono() {
        return Mono.fromFuture(this.taskCompletionFuture);
    }

    private boolean setCompleted() {
        boolean compareAndSet = this.taskStatus.compareAndSet(Status.COMPLETING, Status.COMPLETED);
        Disposable disposable = this.scheduledCompletingTask.get();
        if (disposable != null) {
            disposable.dispose();
        }
        LOGGER.debug("Task is completed");
        this.taskCompletionFuture.obtrudeValue(null);
        return compareAndSet;
    }

    private boolean setCompletedWithError(Throwable throwable) {
        boolean compareAndSet = this.taskStatus.compareAndSet(Status.COMPLETING, Status.COMPLETED);
        Disposable disposable = this.scheduledCompletingTask.get();
        if (disposable != null) {
            disposable.dispose();
        }
        LOGGER.error("Task is completed with error: {}", throwable);
        this.taskCompletionFuture.obtrudeException(throwable);
        return compareAndSet;
    }

    private boolean setScheduled() {
        return this.taskStatus.compareAndSet(null, Status.SCHEDULED);
    }

    private boolean trySetCompleting() {
        return this.taskStatus.compareAndSet(null, Status.COMPLETING) || this.taskStatus.compareAndSet(Status.SCHEDULED, Status.COMPLETING);
    }

    private boolean isCompleted() {
        return this.taskStatus.get() == Status.COMPLETED;
    }

    private boolean isScheduled() {
        return this.taskStatus.get() == Status.SCHEDULED;
    }

    private void startCompleting() {
        if (this.trySetCompleting()) {
            try {
                this.cleanUp.get().subscribe(empty -> this.setCompleted(), ex -> {
                    LOGGER.error("Exception occured on cleanUp, cause: {}", ex);
                    this.setCompletedWithError((Throwable)ex);
                }, this::setCompleted);
            }
            catch (Throwable ex2) {
                LOGGER.error("Exception occured on cleanUp, cause: {}", ex2);
                this.setCompletedWithError(ex2);
            }
        }
    }

    public static enum Status {
        SCHEDULED,
        COMPLETING,
        COMPLETED;

    }
}

