/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.benchmarks.metrics;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import io.scalecube.benchmarks.BenchmarkMetrics;
import io.scalecube.benchmarks.metrics.BenchmarkMeter;
import io.scalecube.benchmarks.metrics.BenchmarkTimer;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class CodahaleBenchmarkMetrics
implements BenchmarkMetrics {
    private final MetricRegistry registry;
    private final Supplier<Boolean> enabled;

    public CodahaleBenchmarkMetrics(MetricRegistry registry, Supplier<Boolean> enabled) {
        this.registry = registry;
        this.enabled = enabled;
    }

    @Override
    public BenchmarkTimer timer(String name) {
        final Timer timer = this.registry.timer(name);
        return new BenchmarkTimer(){

            @Override
            public void update(long value, TimeUnit timeUnit) {
                if (((Boolean)CodahaleBenchmarkMetrics.this.enabled.get()).booleanValue()) {
                    timer.update(value, timeUnit);
                }
            }

            @Override
            public BenchmarkTimer.Context time() {
                if (((Boolean)CodahaleBenchmarkMetrics.this.enabled.get()).booleanValue()) {
                    Timer.Context context = timer.time();
                    return () -> ((Timer.Context)context).stop();
                }
                return NO_OP_CONTEXT;
            }
        };
    }

    @Override
    public BenchmarkMeter meter(String name) {
        final Meter meter = this.registry.meter(name);
        return new BenchmarkMeter(){

            @Override
            public void mark() {
                meter.mark();
            }

            @Override
            public void mark(long value) {
                meter.mark(value);
            }
        };
    }
}

