/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.cluster;

import io.scalecube.cluster.fdetector.FailureDetectorConfig;
import io.scalecube.cluster.gossip.GossipConfig;
import io.scalecube.cluster.membership.MembershipConfig;
import io.scalecube.cluster.metadata.MetadataDecoder;
import io.scalecube.cluster.metadata.MetadataEncoder;
import io.scalecube.cluster.transport.api.TransportConfig;
import java.util.Optional;
import java.util.function.UnaryOperator;
import reactor.core.Exceptions;

public final class ClusterConfig
implements Cloneable {
    public static final int DEFAULT_METADATA_TIMEOUT = 3000;
    public static final int DEFAULT_WAN_METADATA_TIMEOUT = 10000;
    public static final int DEFAULT_LOCAL_METADATA_TIMEOUT = 1000;
    private Object metadata;
    private int metadataTimeout = 3000;
    private MetadataEncoder metadataEncoder = MetadataEncoder.INSTANCE;
    private MetadataDecoder metadataDecoder = MetadataDecoder.INSTANCE;
    private String memberHost;
    private Integer memberPort;
    private TransportConfig transportConfig = TransportConfig.defaultConfig();
    private FailureDetectorConfig failureDetectorConfig = FailureDetectorConfig.defaultConfig();
    private GossipConfig gossipConfig = GossipConfig.defaultConfig();
    private MembershipConfig membershipConfig = MembershipConfig.defaultConfig();

    public static ClusterConfig defaultConfig() {
        return new ClusterConfig();
    }

    public static ClusterConfig defaultLanConfig() {
        return ClusterConfig.defaultConfig();
    }

    public static ClusterConfig defaultWanConfig() {
        return ClusterConfig.defaultConfig().membership(opts -> opts.suspicionMult(6).syncInterval(60000)).transport(opts -> opts.connectTimeout(10000)).metadataTimeout(10000);
    }

    public static ClusterConfig defaultLocalConfig() {
        return ClusterConfig.defaultConfig().membership(opts -> opts.suspicionMult(3).syncInterval(15000)).transport(opts -> opts.connectTimeout(1000)).metadataTimeout(1000);
    }

    public <T> T metadata() {
        return (T)this.metadata;
    }

    public ClusterConfig metadata(Object metadata) {
        ClusterConfig c = this.clone();
        c.metadata = metadata;
        return c;
    }

    public int metadataTimeout() {
        return this.metadataTimeout;
    }

    public ClusterConfig metadataTimeout(int metadataTimeout) {
        ClusterConfig c = this.clone();
        c.metadataTimeout = metadataTimeout;
        return c;
    }

    public MetadataEncoder metadataEncoder() {
        return this.metadataEncoder;
    }

    public ClusterConfig metadataEncoder(MetadataEncoder metadataEncoder) {
        ClusterConfig c = this.clone();
        c.metadataEncoder = metadataEncoder;
        return c;
    }

    public MetadataDecoder metadataDecoder() {
        return this.metadataDecoder;
    }

    public ClusterConfig metadataDecoder(MetadataDecoder metadataDecoder) {
        ClusterConfig c = this.clone();
        c.metadataDecoder = metadataDecoder;
        return c;
    }

    public String memberHost() {
        return this.memberHost;
    }

    public ClusterConfig memberHost(String memberHost) {
        ClusterConfig c = this.clone();
        c.memberHost = memberHost;
        return c;
    }

    public Integer memberPort() {
        return this.memberPort;
    }

    public ClusterConfig memberPort(Integer memberPort) {
        ClusterConfig c = this.clone();
        c.memberPort = memberPort;
        return c;
    }

    public ClusterConfig transport(UnaryOperator<TransportConfig> op) {
        ClusterConfig c = this.clone();
        c.transportConfig = (TransportConfig)op.apply(this.transportConfig);
        return c;
    }

    public TransportConfig transportConfig() {
        return this.transportConfig;
    }

    public ClusterConfig failureDetector(UnaryOperator<FailureDetectorConfig> op) {
        ClusterConfig c = this.clone();
        c.failureDetectorConfig = (FailureDetectorConfig)op.apply(this.failureDetectorConfig);
        return c;
    }

    public FailureDetectorConfig failureDetectorConfig() {
        return this.failureDetectorConfig;
    }

    public ClusterConfig gossip(UnaryOperator<GossipConfig> op) {
        ClusterConfig c = this.clone();
        c.gossipConfig = (GossipConfig)op.apply(this.gossipConfig);
        return c;
    }

    public GossipConfig gossipConfig() {
        return this.gossipConfig;
    }

    public ClusterConfig membership(UnaryOperator<MembershipConfig> op) {
        ClusterConfig c = this.clone();
        c.membershipConfig = (MembershipConfig)op.apply(this.membershipConfig);
        return c;
    }

    public MembershipConfig membershipConfig() {
        return this.membershipConfig;
    }

    public ClusterConfig clone() {
        try {
            ClusterConfig c = (ClusterConfig)super.clone();
            c.transportConfig = this.transportConfig.clone();
            c.failureDetectorConfig = this.failureDetectorConfig.clone();
            c.gossipConfig = this.gossipConfig.clone();
            c.membershipConfig = this.membershipConfig.clone();
            return c;
        }
        catch (CloneNotSupportedException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public String toString() {
        return "ClusterConfig{metadata=" + this.metadataAsString() + ", metadataTimeout=" + this.metadataTimeout + ", metadataEncoder=" + this.metadataEncoder + ", metadataDecoder=" + this.metadataDecoder + ", memberHost='" + this.memberHost + '\'' + ", memberPort=" + this.memberPort + ", transportConfig=" + this.transportConfig + ", failureDetectorConfig=" + this.failureDetectorConfig + ", gossipConfig=" + this.gossipConfig + ", membershipConfig=" + this.membershipConfig + '}';
    }

    private String metadataAsString() {
        return Optional.ofNullable(this.metadata).map(Object::hashCode).map(Integer::toHexString).orElse(null);
    }
}

