/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.cluster.membership;

import io.scalecube.cluster.Member;
import java.nio.ByteBuffer;
import java.util.Objects;

public final class MembershipEvent {
    private final Type type;
    private final Member member;
    private final ByteBuffer oldMetadata;
    private final ByteBuffer newMetadata;

    private MembershipEvent(Type type, Member member, ByteBuffer oldMetadata, ByteBuffer newMetadata) {
        this.type = type;
        this.member = member;
        this.oldMetadata = oldMetadata;
        this.newMetadata = newMetadata;
    }

    public static MembershipEvent createRemoved(Member member, ByteBuffer metadata) {
        Objects.requireNonNull(member, "member must be not null");
        return new MembershipEvent(Type.REMOVED, member, metadata, null);
    }

    public static MembershipEvent createAdded(Member member, ByteBuffer metadata) {
        Objects.requireNonNull(member, "member must be not null");
        return new MembershipEvent(Type.ADDED, member, null, metadata);
    }

    public static MembershipEvent createUpdated(Member member, ByteBuffer oldMetadata, ByteBuffer newMetadata) {
        Objects.requireNonNull(member, "member must be not null");
        return new MembershipEvent(Type.UPDATED, member, oldMetadata, newMetadata);
    }

    public Type type() {
        return this.type;
    }

    public boolean isAdded() {
        return this.type == Type.ADDED;
    }

    public boolean isRemoved() {
        return this.type == Type.REMOVED;
    }

    public boolean isUpdated() {
        return this.type == Type.UPDATED;
    }

    public Member member() {
        return this.member;
    }

    public ByteBuffer oldMetadata() {
        return this.oldMetadata;
    }

    public ByteBuffer newMetadata() {
        return this.newMetadata;
    }

    public String toString() {
        return "MembershipEvent{type=" + (Object)((Object)this.type) + ", member=" + this.member + ", newMetadata=" + this.metadataAsString(this.newMetadata) + ", oldMetadata=" + this.metadataAsString(this.oldMetadata) + '}';
    }

    private String metadataAsString(ByteBuffer metadata) {
        if (metadata == null) {
            return null;
        }
        return Integer.toHexString(metadata.hashCode()) + "-" + metadata.remaining();
    }

    public static enum Type {
        ADDED,
        REMOVED,
        UPDATED;

    }
}

