/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.examples;

import io.scalecube.cluster.Cluster;
import io.scalecube.cluster.ClusterConfig;
import io.scalecube.cluster.ClusterImpl;
import io.scalecube.cluster.Member;
import io.scalecube.net.Address;
import io.scalecube.transport.netty.tcp.TcpTransportFactory;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

public class ClusterJoinExamples {
    public static void main(String[] args) {
        Cluster alice = new ClusterImpl().config(opts -> opts.memberAlias("Alice")).transportFactory(TcpTransportFactory::new).startAwait();
        Cluster bob = new ClusterImpl().config(opts -> opts.memberAlias("Bob")).membership(opts -> opts.seedMembers(alice.addresses())).transportFactory(TcpTransportFactory::new).startAwait();
        Map<String, String> metadata = Collections.singletonMap("name", "Carol");
        Cluster carol = new ClusterImpl().config(opts -> opts.memberAlias("Carol").metadata((Object)metadata)).membership(opts -> opts.seedMembers(alice.addresses())).transportFactory(TcpTransportFactory::new).startAwait();
        ClusterConfig configWithFixedPort = new ClusterConfig().memberAlias("Dan").membership(opts -> opts.seedMembers(alice.addresses())).transport(opts -> opts.port(3000));
        Cluster dan = new ClusterImpl(configWithFixedPort).transportFactory(TcpTransportFactory::new).startAwait();
        ClusterConfig configWithSyncGroup = new ClusterConfig().memberAlias("Eve").membership(opts -> opts.seedMembers(new Address[]{(Address)alice.addresses().get(0), (Address)bob.addresses().get(0), (Address)carol.addresses().get(0), (Address)dan.addresses().get(0)}).namespace("another-cluster"));
        Cluster eve = new ClusterImpl(configWithSyncGroup).transportFactory(TcpTransportFactory::new).startAwait();
        System.out.println("Alice (" + alice.addresses() + ") cluster: " + alice.members().stream().map(Member::toString).collect(Collectors.joining("\n", "\n", "\n")));
        System.out.println("Bob (" + bob.addresses() + ") cluster: " + bob.members().stream().map(Member::toString).collect(Collectors.joining("\n", "\n", "\n")));
        System.out.println("Carol (" + carol.addresses() + ") cluster: " + carol.members().stream().map(Member::toString).collect(Collectors.joining("\n", "\n", "\n")));
        System.out.println("Dan (" + dan.addresses() + ") cluster: " + dan.members().stream().map(Member::toString).collect(Collectors.joining("\n", "\n", "\n")));
        System.out.println("Eve (" + eve.addresses() + ") cluster: " + eve.members().stream().map(Member::toString).collect(Collectors.joining("\n", "\n", "\n")));
    }
}

