/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.examples;

import io.scalecube.cluster.Cluster;
import io.scalecube.cluster.ClusterImpl;
import io.scalecube.cluster.ClusterMessageHandler;
import io.scalecube.cluster.Member;
import io.scalecube.cluster.transport.api.Message;
import io.scalecube.transport.netty.tcp.TcpTransportFactory;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class ClusterMetadataExample {
    public static void main(String[] args) throws Exception {
        Cluster alice = new ClusterImpl().transportFactory(TcpTransportFactory::new).startAwait();
        Cluster joe = new ClusterImpl().config(opts -> opts.metadata(Collections.singletonMap("name", "Joe"))).membership(opts -> opts.seedMembers(alice.addresses())).transportFactory(TcpTransportFactory::new).handler(cluster -> new ClusterMessageHandler(){

            public void onMessage(Message message) {
                System.out.println("joe.listen(): " + message.data());
            }
        }).startAwait();
        Optional joeMemberOptional = alice.otherMembers().stream().findAny();
        System.err.println("### joeMemberOptional: " + joeMemberOptional);
        System.err.println("### joeMetadata: " + alice.metadata((Member)joeMemberOptional.get()));
        joeMemberOptional.ifPresent(member -> alice.send(member, Message.withData((Object)"Hello Joe").build()).subscribe(null, ex -> {}));
        TimeUnit.SECONDS.sleep(3L);
    }
}

