/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.examples;

import io.scalecube.cluster.Cluster;
import io.scalecube.cluster.ClusterImpl;
import io.scalecube.cluster.ClusterMath;
import io.scalecube.cluster.ClusterMessageHandler;
import io.scalecube.cluster.membership.MembershipEvent;
import io.scalecube.transport.netty.tcp.TcpTransportFactory;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;

public class MembershipEventsExample {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss.SSS");

    public static void main(String[] args) throws Exception {
        Cluster alice = new ClusterImpl().config(opts -> opts.memberAlias("Alice")).config(opts -> opts.metadata(Collections.singletonMap("name", "Alice"))).transportFactory(TcpTransportFactory::new).handler(cluster -> new ClusterMessageHandler(){

            public void onMembershipEvent(MembershipEvent event) {
                System.out.println(MembershipEventsExample.now() + " Alice received: " + event);
            }
        }).startAwait();
        System.out.println(MembershipEventsExample.now() + " Alice join members: " + alice.members());
        Cluster bob = new ClusterImpl().config(opts -> opts.memberAlias("Bob")).config(opts -> opts.metadata(Collections.singletonMap("name", "Bob"))).membership(opts -> opts.seedMembers(alice.addresses())).transportFactory(TcpTransportFactory::new).handler(cluster -> new ClusterMessageHandler(){

            public void onMembershipEvent(MembershipEvent event) {
                System.out.println(MembershipEventsExample.now() + " Bob received: " + event);
            }
        }).startAwait();
        System.out.println(MembershipEventsExample.now() + " Bob join members: " + bob.members());
        Cluster carol = new ClusterImpl().config(opts -> opts.memberAlias("Carol")).config(opts -> opts.metadata(Collections.singletonMap("name", "Carol"))).membership(opts -> opts.seedMembers(bob.addresses())).transportFactory(TcpTransportFactory::new).handler(cluster -> new ClusterMessageHandler(){

            public void onMembershipEvent(MembershipEvent event) {
                System.out.println(MembershipEventsExample.now() + " Carol received: " + event);
            }
        }).startAwait();
        System.out.println(MembershipEventsExample.now() + " Carol join members: " + carol.members());
        bob.shutdown();
        bob.onShutdown().block();
        long pingInterval = 1000L;
        long suspicionTimeout = ClusterMath.suspicionTimeout((int)5, (int)4, (long)pingInterval);
        long maxRemoveTimeout = suspicionTimeout + 3L * pingInterval;
        Thread.sleep(maxRemoveTimeout);
    }

    private static String now() {
        return sdf.format(new Date());
    }
}

