/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.examples;

import io.scalecube.cluster.Cluster;
import io.scalecube.cluster.ClusterImpl;
import io.scalecube.cluster.ClusterMessageHandler;
import io.scalecube.cluster.transport.api.Message;
import io.scalecube.net.Address;
import io.scalecube.transport.netty.websocket.WebsocketTransportFactory;
import reactor.core.publisher.Flux;

public class WebsocketMessagingExample {
    public static void main(String[] args) throws Exception {
        Cluster alice = new ClusterImpl().transportFactory(WebsocketTransportFactory::new).handler(cluster -> new ClusterMessageHandler((Cluster)cluster){
            final /* synthetic */ Cluster val$cluster;
            {
                this.val$cluster = cluster;
            }

            public void onMessage(Message msg) {
                System.out.println("Alice received: " + msg.data());
                this.val$cluster.send(msg.sender(), Message.fromData((Object)"Greetings from Alice")).subscribe(null, Throwable::printStackTrace);
            }
        }).startAwait();
        Cluster bob = new ClusterImpl().transportFactory(WebsocketTransportFactory::new).membership(opts -> opts.seedMembers(alice.addresses())).handler(cluster -> new ClusterMessageHandler((Cluster)cluster){
            final /* synthetic */ Cluster val$cluster;
            {
                this.val$cluster = cluster;
            }

            public void onMessage(Message msg) {
                System.out.println("Bob received: " + msg.data());
                this.val$cluster.send(msg.sender(), Message.fromData((Object)"Greetings from Bob")).subscribe(null, Throwable::printStackTrace);
            }
        }).startAwait();
        Cluster carol = new ClusterImpl().transportFactory(WebsocketTransportFactory::new).membership(opts -> opts.seedMembers(new Address[]{(Address)alice.addresses().get(0), (Address)bob.addresses().get(0)})).handler(cluster -> new ClusterMessageHandler(){

            public void onMessage(Message msg) {
                System.out.println("Carol received: " + msg.data());
            }
        }).startAwait();
        Message greetingMsg = Message.fromData((Object)"Greetings from Carol");
        Flux.fromIterable((Iterable)carol.otherMembers()).flatMap(member -> carol.send(member, greetingMsg)).subscribe(null, Throwable::printStackTrace);
        Thread.sleep(1000L);
    }
}

