/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.cluster.fdetector;

import io.scalecube.cluster.Member;

final class PingData {
    private Member from;
    private Member to;
    private Member originalIssuer;
    private AckType ackType;

    PingData() {
    }

    private PingData(PingData other) {
        this.from = other.from;
        this.to = other.to;
        this.originalIssuer = other.originalIssuer;
        this.ackType = other.ackType;
    }

    public PingData(Member from, Member to) {
        this.from = from;
        this.to = to;
        this.originalIssuer = null;
        this.ackType = null;
    }

    public PingData(Member from, Member to, Member originalIssuer) {
        this.from = from;
        this.to = to;
        this.originalIssuer = originalIssuer;
        this.ackType = null;
    }

    public Member getFrom() {
        return this.from;
    }

    public Member getTo() {
        return this.to;
    }

    public Member getOriginalIssuer() {
        return this.originalIssuer;
    }

    public AckType getAckType() {
        return this.ackType;
    }

    public PingData withAckType(AckType ackType) {
        PingData p = new PingData(this);
        p.ackType = ackType;
        return p;
    }

    public String toString() {
        return "PingData{from=" + this.from + ", to=" + this.to + ", originalIssuer=" + this.originalIssuer + ", ackType=" + (Object)((Object)this.ackType) + '}';
    }

    static enum AckType {
        DEST_OK,
        DEST_GONE;

    }
}

