/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.cluster.gossip;

import io.scalecube.cluster.ClusterMath;
import io.scalecube.cluster.Member;
import io.scalecube.cluster.gossip.Gossip;
import io.scalecube.cluster.gossip.GossipConfig;
import io.scalecube.cluster.gossip.GossipProtocol;
import io.scalecube.cluster.gossip.GossipRequest;
import io.scalecube.cluster.gossip.GossipState;
import io.scalecube.cluster.membership.MembershipEvent;
import io.scalecube.cluster.transport.api.Message;
import io.scalecube.cluster.transport.api.Transport;
import io.scalecube.net.Address;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.Disposables;
import reactor.core.publisher.DirectProcessor;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxProcessor;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.core.scheduler.Scheduler;

public final class GossipProtocolImpl
implements GossipProtocol {
    private static final Logger LOGGER = LoggerFactory.getLogger(GossipProtocolImpl.class);
    public static final String GOSSIP_REQ = "sc/gossip/req";
    private final Member localMember;
    private final Transport transport;
    private final GossipConfig config;
    private long currentPeriod = 0L;
    private long gossipCounter = 0L;
    private Map<String, GossipState> gossips = new HashMap<String, GossipState>();
    private Map<String, MonoSink<String>> futures = new HashMap<String, MonoSink<String>>();
    private List<Member> remoteMembers = new ArrayList<Member>();
    private int remoteMembersIndex = -1;
    private final Disposable.Composite actionsDisposables = Disposables.composite();
    private final FluxProcessor<Message, Message> subject = DirectProcessor.create().serialize();
    private final FluxSink<Message> sink = this.subject.sink();
    private final Scheduler scheduler;

    public GossipProtocolImpl(Member localMember, Transport transport, Flux<MembershipEvent> membershipProcessor, GossipConfig config, Scheduler scheduler) {
        this.transport = Objects.requireNonNull(transport);
        this.config = Objects.requireNonNull(config);
        this.localMember = Objects.requireNonNull(localMember);
        this.scheduler = Objects.requireNonNull(scheduler);
        this.actionsDisposables.addAll(Arrays.asList(membershipProcessor.publishOn(scheduler).subscribe(this::onMemberEvent, this::onError), transport.listen().publishOn(scheduler).filter(this::isGossipReq).subscribe(this::onGossipReq, this::onError)));
    }

    @Override
    public void start() {
        this.actionsDisposables.add(this.scheduler.schedulePeriodically(this::doSpreadGossip, this.config.gossipInterval(), this.config.gossipInterval(), TimeUnit.MILLISECONDS));
    }

    @Override
    public void stop() {
        this.actionsDisposables.dispose();
        this.sink.complete();
    }

    @Override
    public Mono<String> spread(Message message) {
        return Mono.fromCallable(() -> message).subscribeOn(this.scheduler).flatMap(msg -> Mono.create(sink -> this.futures.put(this.createAndPutGossip((Message)msg), (MonoSink<String>)sink)));
    }

    @Override
    public Flux<Message> listen() {
        return this.subject.onBackpressureBuffer();
    }

    private void doSpreadGossip() {
        long period = this.currentPeriod++;
        if (this.gossips.isEmpty()) {
            return;
        }
        try {
            this.selectGossipMembers().forEach(member -> this.spreadGossipsTo(period, (Member)member));
            this.sweepGossips(period);
        }
        catch (Exception ex) {
            LOGGER.warn("Exception at doSpreadGossip[{}]: {}", new Object[]{period, ex.getMessage(), ex});
        }
    }

    private String createAndPutGossip(Message message) {
        long period = this.currentPeriod;
        Gossip gossip = new Gossip(this.generateGossipId(), message);
        GossipState gossipState = new GossipState(gossip, period);
        this.gossips.put(gossip.gossipId(), gossipState);
        return gossip.gossipId();
    }

    private void onGossipReq(Message message) {
        long period = this.currentPeriod;
        GossipRequest gossipRequest = (GossipRequest)message.data();
        for (Gossip gossip : gossipRequest.gossips()) {
            GossipState gossipState = this.gossips.get(gossip.gossipId());
            if (gossipState == null) {
                gossipState = new GossipState(gossip, period);
                this.gossips.put(gossip.gossipId(), gossipState);
                this.sink.next((Object)gossip.message());
            }
            gossipState.addToInfected(gossipRequest.from());
        }
    }

    private void onMemberEvent(MembershipEvent event) {
        boolean removed;
        Member member = event.member();
        if (event.isRemoved() && (removed = this.remoteMembers.remove(member))) {
            LOGGER.debug("Removed {} from remoteMembers list (size={})", (Object)member, (Object)this.remoteMembers.size());
        }
        if (event.isAdded()) {
            this.remoteMembers.add(member);
            LOGGER.debug("Added {} to remoteMembers list (size={})", (Object)member, (Object)this.remoteMembers.size());
        }
    }

    private void onError(Throwable throwable) {
        LOGGER.error("Received unexpected error: ", throwable);
    }

    private boolean isGossipReq(Message message) {
        return GOSSIP_REQ.equals(message.qualifier());
    }

    private String generateGossipId() {
        return this.localMember.id() + "-" + this.gossipCounter++;
    }

    private void spreadGossipsTo(long period, Member member) {
        List<Gossip> gossips = this.selectGossipsToSend(period, member);
        if (gossips.isEmpty()) {
            return;
        }
        Address address = member.address();
        gossips.stream().map(this::buildGossipRequestMessage).forEach(message -> this.transport.send(address, message).subscribe(null, ex -> LOGGER.debug("Failed to send GossipReq[{}]: {} to {}, cause: {}", new Object[]{period, message, address, ex.toString()})));
    }

    private List<Gossip> selectGossipsToSend(long period, Member member) {
        int periodsToSpread = ClusterMath.gossipPeriodsToSpread(this.config.gossipRepeatMult(), this.remoteMembers.size() + 1);
        return this.gossips.values().stream().filter(gossipState -> gossipState.infectionPeriod() + (long)periodsToSpread >= period).filter(gossipState -> !gossipState.isInfected(member.id())).map(GossipState::gossip).collect(Collectors.toList());
    }

    private List<Member> selectGossipMembers() {
        int gossipFanout = this.config.gossipFanout();
        if (this.remoteMembers.size() < gossipFanout) {
            return this.remoteMembers;
        }
        if (this.remoteMembersIndex < 0 || this.remoteMembersIndex + gossipFanout > this.remoteMembers.size()) {
            Collections.shuffle(this.remoteMembers);
            this.remoteMembersIndex = 0;
        }
        List<Member> selectedMembers = gossipFanout == 1 ? Collections.singletonList(this.remoteMembers.get(this.remoteMembersIndex)) : this.remoteMembers.subList(this.remoteMembersIndex, this.remoteMembersIndex + gossipFanout);
        this.remoteMembersIndex += gossipFanout;
        return selectedMembers;
    }

    private Message buildGossipRequestMessage(Gossip gossip) {
        GossipRequest gossipRequest = new GossipRequest(gossip, this.localMember.id());
        return Message.withData((Object)gossipRequest).qualifier(GOSSIP_REQ).build();
    }

    private void sweepGossips(long period) {
        int periodsToSweep = ClusterMath.gossipPeriodsToSweep(this.config.gossipRepeatMult(), this.remoteMembers.size() + 1);
        Set gossipsToRemove = this.gossips.values().stream().filter(gossipState -> period > gossipState.infectionPeriod() + (long)periodsToSweep).collect(Collectors.toSet());
        if (gossipsToRemove.isEmpty()) {
            return;
        }
        LOGGER.debug("Sweep gossips[{}]: {}", (Object)period, gossipsToRemove);
        for (GossipState gossipState2 : gossipsToRemove) {
            this.gossips.remove(gossipState2.gossip().gossipId());
            MonoSink<String> sink = this.futures.remove(gossipState2.gossip().gossipId());
            if (sink == null) continue;
            sink.success((Object)gossipState2.gossip().gossipId());
        }
    }

    Transport getTransport() {
        return this.transport;
    }

    Member getMember() {
        return this.localMember;
    }
}

