/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.cluster.membership;

import io.scalecube.cluster.Member;
import io.scalecube.cluster.membership.MemberStatus;
import io.scalecube.net.Address;
import java.util.Objects;

final class MembershipRecord {
    private Member member;
    private MemberStatus status;
    private int incarnation;

    MembershipRecord() {
    }

    public MembershipRecord(Member member, MemberStatus status, int incarnation) {
        this.member = Objects.requireNonNull(member);
        this.status = Objects.requireNonNull(status);
        this.incarnation = incarnation;
    }

    public Member member() {
        return this.member;
    }

    public String id() {
        return this.member.id();
    }

    public Address address() {
        return this.member.address();
    }

    public MemberStatus status() {
        return this.status;
    }

    public boolean isAlive() {
        return this.status == MemberStatus.ALIVE;
    }

    public boolean isSuspect() {
        return this.status == MemberStatus.SUSPECT;
    }

    public boolean isDead() {
        return this.status == MemberStatus.DEAD;
    }

    public int incarnation() {
        return this.incarnation;
    }

    public boolean isOverrides(MembershipRecord r0) {
        if (r0 == null) {
            return this.isAlive();
        }
        if (!Objects.equals(this.member.id(), r0.member.id())) {
            throw new IllegalArgumentException("Can't compare records for different members");
        }
        if (r0.isDead()) {
            return false;
        }
        if (this.isDead()) {
            return true;
        }
        if (this.incarnation == r0.incarnation) {
            return this.status != r0.status && this.isSuspect();
        }
        return this.incarnation > r0.incarnation;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        MembershipRecord record = (MembershipRecord)that;
        return this.incarnation == record.incarnation && Objects.equals(this.member, record.member) && this.status == record.status;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.member, this.status, this.incarnation});
    }

    public String toString() {
        return "{m: " + this.member + ", s: " + (Object)((Object)this.status) + ", inc: " + this.incarnation + '}';
    }
}

