/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.cluster.membership;

import io.scalecube.cluster.membership.MembershipRecord;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

final class SyncData
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private List<MembershipRecord> membership;
    private String syncGroup;

    public SyncData() {
    }

    public SyncData(Collection<MembershipRecord> membership, String syncGroup) {
        Objects.requireNonNull(membership);
        Objects.requireNonNull(syncGroup);
        this.membership = Collections.unmodifiableList(new ArrayList<MembershipRecord>(membership));
        this.syncGroup = syncGroup;
    }

    public Collection<MembershipRecord> getMembership() {
        return this.membership;
    }

    public String getSyncGroup() {
        return this.syncGroup;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.membership.size());
        for (MembershipRecord record : this.membership) {
            out.writeObject(record);
        }
        out.writeUTF(this.syncGroup);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int membershipSize = in.readInt();
        ArrayList<MembershipRecord> membership = new ArrayList<MembershipRecord>(membershipSize);
        for (int i = 0; i < membershipSize; ++i) {
            membership.add((MembershipRecord)in.readObject());
        }
        this.membership = Collections.unmodifiableList(membership);
        this.syncGroup = in.readUTF();
    }

    public String toString() {
        return new StringJoiner(", ", SyncData.class.getSimpleName() + "[", "]").add("membership=" + this.membership).add("syncGroup='" + this.syncGroup + "'").toString();
    }
}

