/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.cluster.metadata;

import io.scalecube.cluster.ClusterConfig;
import io.scalecube.cluster.CorrelationIdGenerator;
import io.scalecube.cluster.Member;
import io.scalecube.cluster.metadata.GetMetadataRequest;
import io.scalecube.cluster.metadata.GetMetadataResponse;
import io.scalecube.cluster.metadata.MetadataStore;
import io.scalecube.cluster.transport.api.Message;
import io.scalecube.cluster.transport.api.Transport;
import io.scalecube.net.Address;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.Disposables;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;

public class MetadataStoreImpl
implements MetadataStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetadataStore.class);
    public static final String GET_METADATA_REQ = "sc/metadata/req";
    public static final String GET_METADATA_RESP = "sc/metadata/resp";
    public static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    private Object localMetadata;
    private final Member localMember;
    private final Transport transport;
    private final ClusterConfig config;
    private final CorrelationIdGenerator cidGenerator;
    private final Map<Member, ByteBuffer> membersMetadata = new HashMap<Member, ByteBuffer>();
    private final Scheduler scheduler;
    private final Disposable.Composite actionsDisposables = Disposables.composite();

    public MetadataStoreImpl(Member localMember, Transport transport, Object localMetadata, ClusterConfig config, Scheduler scheduler, CorrelationIdGenerator cidGenerator) {
        this.localMember = Objects.requireNonNull(localMember);
        this.transport = Objects.requireNonNull(transport);
        this.config = Objects.requireNonNull(config);
        this.scheduler = Objects.requireNonNull(scheduler);
        this.cidGenerator = Objects.requireNonNull(cidGenerator);
        this.localMetadata = localMetadata;
    }

    public void start() {
        this.actionsDisposables.add(this.transport.listen().publishOn(this.scheduler).subscribe(this::onMessage, this::onError));
    }

    public void stop() {
        this.actionsDisposables.dispose();
        this.membersMetadata.clear();
    }

    public <T> Optional<T> metadata() {
        return Optional.ofNullable(this.localMetadata);
    }

    public Optional<ByteBuffer> metadata(Member member) {
        return Optional.ofNullable(this.membersMetadata.get(member)).map(ByteBuffer::slice);
    }

    public void updateMetadata(Object metadata) {
        this.localMetadata = metadata;
    }

    public ByteBuffer updateMetadata(Member member, ByteBuffer metadata) {
        if (this.localMember.equals((Object)member)) {
            throw new IllegalArgumentException("removeMetadata must not accept local member");
        }
        ByteBuffer value = metadata.slice();
        ByteBuffer result = this.membersMetadata.put(member, value);
        if (result == null) {
            LOGGER.debug("[{}] Added metadata(size={}) for member {}", new Object[]{this.localMember, value.remaining(), member});
        } else {
            LOGGER.debug("[{}] Updated metadata(size={}) for member {}", new Object[]{this.localMember, value.remaining(), member});
        }
        return result;
    }

    public ByteBuffer removeMetadata(Member member) {
        if (this.localMember.equals((Object)member)) {
            throw new IllegalArgumentException("removeMetadata must not accept local member");
        }
        ByteBuffer metadata = this.membersMetadata.remove(member);
        if (metadata != null) {
            LOGGER.debug("[{}] Removed metadata(size={}) for member {}", new Object[]{this.localMember, metadata.remaining(), member});
            return metadata;
        }
        return null;
    }

    public Mono<ByteBuffer> fetchMetadata(Member member) {
        return Mono.defer(() -> {
            String cid = this.cidGenerator.nextCid();
            Address targetAddress = member.address();
            LOGGER.debug("[{}][{}] Getting metadata for member {}", new Object[]{this.localMember, cid, member});
            Message request = Message.builder().qualifier(GET_METADATA_REQ).correlationId(cid).data((Object)new GetMetadataRequest(member)).build();
            return this.transport.requestResponse(targetAddress, request).timeout(Duration.ofMillis(this.config.metadataTimeout()), this.scheduler).publishOn(this.scheduler).doOnSuccess(s -> LOGGER.debug("[{}][{}] Received GetMetadataResp from {}", new Object[]{this.localMember, cid, targetAddress})).map(Message::data).map(GetMetadataResponse::getMetadata).doOnError(th -> LOGGER.warn("[{}][{}] Timeout getting GetMetadataResp from {} within {} ms, cause: {}", new Object[]{this.localMember, cid, targetAddress, this.config.metadataTimeout(), th.toString()}));
        });
    }

    private void onMessage(Message message) {
        if (GET_METADATA_REQ.equals(message.qualifier())) {
            this.onMetadataRequest(message);
        }
    }

    private void onError(Throwable throwable) {
        LOGGER.error("[{}] Received unexpected error:", (Object)this.localMember, (Object)throwable);
    }

    private void onMetadataRequest(Message message) {
        Address sender = message.sender();
        LOGGER.debug("[{}] Received GetMetadataReq from {}", (Object)this.localMember, (Object)sender);
        GetMetadataRequest reqData = (GetMetadataRequest)message.data();
        Member targetMember = reqData.getMember();
        if (!targetMember.id().equals(this.localMember.id())) {
            LOGGER.warn("[{}] Received GetMetadataReq from {} to {}, but local member is {}", new Object[]{this.localMember, sender, targetMember, this.localMember});
            return;
        }
        GetMetadataResponse respData = new GetMetadataResponse(this.localMember, this.encodeMetadata());
        Message response = Message.builder().qualifier(GET_METADATA_RESP).correlationId(message.correlationId()).data((Object)respData).build();
        LOGGER.debug("[{}] Send GetMetadataResp to {}", (Object)this.localMember, (Object)sender);
        this.transport.send(sender, response).subscribe(null, ex -> LOGGER.debug("[{}] Failed to send GetMetadataResp to {}, cause: {}", new Object[]{this.localMember, sender, ex.toString()}));
    }

    private ByteBuffer encodeMetadata() {
        ByteBuffer result = this.config.metadataEncoder() != null ? this.config.metadataEncoder().encode(this.localMetadata) : this.config.metadataCodec().serialize(this.localMetadata);
        return Optional.ofNullable(result).orElse(EMPTY_BUFFER);
    }
}

