/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.gateway.rsocket.websocket;

import io.scalecube.config.ConfigRegistry;
import io.scalecube.gateway.config.GatewayConfigRegistry;
import io.scalecube.gateway.rsocket.websocket.RSocketWebsocketServer;
import io.scalecube.services.Microservices;
import io.scalecube.transport.Address;
import java.util.Collections;
import java.util.List;

public class RSocketWebsocketGatewayRunner {
    private static final String SEEDS = "SEEDS";
    private static final List<String> DEFAULT_SEEDS = Collections.singletonList("localhost:4802");

    public static void main(String[] args) throws InterruptedException {
        ConfigRegistry configRegistry = GatewayConfigRegistry.configRegistry();
        Address[] seeds = (Address[])configRegistry.stringListValue(SEEDS, DEFAULT_SEEDS).stream().map(Address::from).toArray(Address[]::new);
        Microservices seed = Microservices.builder().seeds(seeds).startAwait();
        RSocketWebsocketServer gateway = new RSocketWebsocketServer(seed);
        gateway.start();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> ((RSocketWebsocketServer)gateway).stop()));
        Thread.currentThread().join();
    }
}

