/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.gateway.http;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.scalecube.gateway.http.GatewayHttpServer;

@ChannelHandler.Sharable
public final class CorsHeadersHandler
extends ChannelInboundHandlerAdapter {
    private final GatewayHttpServer.Config config;

    public CorsHeadersHandler(GatewayHttpServer.Config config) {
        this.config = config;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!(msg instanceof FullHttpRequest)) {
            super.channelRead(ctx, msg);
            return;
        }
        FullHttpRequest request = (FullHttpRequest)msg;
        if (!HttpMethod.OPTIONS.equals((Object)request.method())) {
            super.channelRead(ctx, msg);
            return;
        }
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.headers().add((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, (Object)this.config.getAccessControlAllowOrigin());
        response.headers().add((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_METHODS, (Object)this.config.getAccessControlAllowMethods());
        String accessControlRequestHeaders = request.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_REQUEST_HEADERS);
        if (accessControlRequestHeaders != null) {
            response.headers().add((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS, (Object)accessControlRequestHeaders);
        }
        response.headers().add((CharSequence)HttpHeaderNames.ACCESS_CONTROL_MAX_AGE, (Object)this.config.getAccessControlMaxAge());
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        ctx.writeAndFlush((Object)response);
    }
}

