/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.gateway.http;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.ssl.SslHandler;
import io.scalecube.gateway.http.CorsHeadersHandler;
import io.scalecube.gateway.http.GatewayHttpMessageHandler;
import io.scalecube.gateway.http.GatewayHttpServer;
import io.scalecube.ipc.EventStream;
import io.scalecube.ipc.ServerStream;
import io.scalecube.ipc.netty.ChannelContextHandler;
import javax.net.ssl.SSLEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public final class GatewayHttpChannelInitializer
extends ChannelInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(GatewayHttpChannelInitializer.class);
    private final GatewayHttpServer.Config config;
    private final ChannelContextHandler channelContextHandler;
    private final CorsHeadersHandler corsHeadersHandler;
    private final GatewayHttpMessageHandler messageHandler;

    public GatewayHttpChannelInitializer(GatewayHttpServer.Config config) {
        this.config = config;
        this.corsHeadersHandler = new CorsHeadersHandler(config);
        this.messageHandler = new GatewayHttpMessageHandler();
        ServerStream serverStream = config.getServerStream();
        this.channelContextHandler = new ChannelContextHandler(arg_0 -> ((EventStream)serverStream).subscribe(arg_0));
    }

    protected void initChannel(Channel channel) {
        ChannelPipeline pipeline = channel.pipeline();
        channel.pipeline().addLast(new ChannelHandler[]{this.channelContextHandler});
        if (this.config.getSslContext() != null) {
            SSLEngine sslEngine = this.config.getSslContext().createSSLEngine();
            sslEngine.setUseClientMode(false);
            pipeline.addLast(new ChannelHandler[]{new SslHandler(sslEngine)});
        }
        pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
        pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(this.config.getMaxFrameLength(), true)});
        if (this.config.isCorsEnabled()) {
            pipeline.addLast(new ChannelHandler[]{this.corsHeadersHandler});
        }
        pipeline.addLast(new ChannelHandler[]{this.messageHandler});
        pipeline.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                LOGGER.warn("Exception caught for channel {}, {}", new Object[]{ctx.channel(), cause.getMessage(), cause});
            }
        }});
    }
}

