/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.gateway.http;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.util.AttributeMap;
import io.netty.util.concurrent.GenericFutureListener;
import io.scalecube.gateway.http.HttpCodecUtil;
import io.scalecube.ipc.ChannelContext;
import io.scalecube.ipc.ErrorData;
import io.scalecube.ipc.Qualifier;
import io.scalecube.ipc.ServiceMessage;
import io.scalecube.ipc.netty.ChannelSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public final class GatewayHttpMessageHandler
extends ChannelDuplexHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(GatewayHttpMessageHandler.class);

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        ChannelContext channelContext = ChannelSupport.getChannelContextIfExist((AttributeMap)ctx);
        if (channelContext == null) {
            LOGGER.error("Can't find channel context on channel: {}", (Object)ctx.channel());
            ctx.channel().close();
            return;
        }
        channelContext.listenMessageWrite().subscribe(event -> {
            ServiceMessage message = (ServiceMessage)event.getMessage().get();
            Qualifier qualifier = Qualifier.fromString((String)message.getQualifier());
            FullHttpResponse response = !"io.scalecube.ipc.error".equalsIgnoreCase(qualifier.getNamespace()) ? (message.hasData() ? HttpCodecUtil.okResponse((ByteBuf)message.getData()) : HttpCodecUtil.emptyResponse()) : (message.dataOfType(ErrorData.class) ? HttpCodecUtil.errorResponse(qualifier, (ErrorData)message.getData()) : (message.dataOfType(ByteBuf.class) ? HttpCodecUtil.errorResponse(qualifier, (ByteBuf)message.getData()) : HttpCodecUtil.emptyErrorResponse(qualifier)));
            ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                if (!future.isSuccess()) {
                    channelContext.postWriteError(future.cause(), message);
                } else {
                    channelContext.postWriteSuccess(message);
                }
            }));
        }, throwable -> {
            LOGGER.error("Fatal exception occured on channel context: {}, cause: {}", (Object)channelContext.getId(), throwable);
            ctx.channel().close();
        });
        super.channelActive(ctx);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!(msg instanceof FullHttpRequest)) {
            super.channelRead(ctx, msg);
            return;
        }
        ChannelContext channelContext = ChannelSupport.getChannelContextIfExist((AttributeMap)ctx);
        if (channelContext == null) {
            LOGGER.error("Failed to handle message, channel context is null on channel: {}", (Object)ctx.channel());
            ChannelSupport.releaseRefCount((Object)msg);
            ctx.channel().close();
            return;
        }
        try {
            FullHttpRequest request = (FullHttpRequest)msg;
            String qualifier = request.uri().substring(1);
            ServiceMessage.Builder builder = ServiceMessage.withQualifier((String)qualifier);
            if (request.content().isReadable()) {
                builder.data((Object)request.content());
            }
            channelContext.postReadSuccess(builder.build());
        }
        catch (Exception throwable) {
            ChannelSupport.releaseRefCount((Object)msg);
            channelContext.postReadError((Throwable)throwable);
        }
    }
}

