/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.gateway.http;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.scalecube.gateway.http.GatewayHttpChannelInitializer;
import io.scalecube.ipc.ServerStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.function.Consumer;
import javax.net.ssl.SSLContext;

public final class GatewayHttpServer {
    private final Config config;
    private Channel serverChannel;
    private boolean started = false;

    private GatewayHttpServer(Config config) {
        this.config = config;
    }

    public static GatewayHttpServer onPort(int port, ServerStream serverStream) {
        Config config = new Config();
        config.port = port;
        config.serverStream = serverStream;
        return new GatewayHttpServer(config);
    }

    public GatewayHttpServer withServerBootstrap(ServerBootstrap serverBootstrap) {
        return new GatewayHttpServer(this.config.setServerBootstrap(serverBootstrap));
    }

    public GatewayHttpServer withSsl(SSLContext sslContext) {
        return new GatewayHttpServer(this.config.setSslContext(sslContext));
    }

    public GatewayHttpServer withMaxFrameLength(int maxFrameLength) {
        return new GatewayHttpServer(this.config.setMaxFrameLength(maxFrameLength));
    }

    public GatewayHttpServer withCorsEnabled(boolean corsEnabled) {
        return new GatewayHttpServer(this.config.setCorsEnabled(corsEnabled));
    }

    public GatewayHttpServer withAccessControlAllowOrigin(String accessControlAllowOrigin) {
        return new GatewayHttpServer(this.config.setAccessControlAllowOrigin(accessControlAllowOrigin));
    }

    public GatewayHttpServer withAccessControlAllowMethods(String accessControlAllowMethods) {
        return new GatewayHttpServer(this.config.setAccessControlAllowMethods(accessControlAllowMethods));
    }

    public GatewayHttpServer withAccessControlMaxAge(int accessControlMaxAge) {
        return new GatewayHttpServer(this.config.setAccessControlMaxAge(accessControlMaxAge));
    }

    public synchronized void start() {
        if (this.started) {
            throw new IllegalStateException("Failed to start server: already started");
        }
        ServerBootstrap serverBootstrap = this.config.serverBootstrap;
        this.serverChannel = serverBootstrap.childHandler((ChannelHandler)new GatewayHttpChannelInitializer(this.config)).bind((SocketAddress)new InetSocketAddress(this.config.port)).syncUninterruptibly().channel();
        this.started = true;
    }

    public synchronized void stop() {
        if (!this.started) {
            throw new IllegalStateException("Failed to stop server: already stopped");
        }
        this.serverChannel.close().syncUninterruptibly();
        this.started = false;
    }

    public static class Config {
        private static final int DEFAULT_MAX_FRAME_LENGTH = 2048000;
        private static final boolean DEFAULT_CORS_ENABLED = false;
        private static final String DEFAULT_ACCESS_CONTROL_ALLOW_ORIGIN = "*";
        private static final String DEFAULT_ACCESS_CONTROL_ALLOW_METHODS = "GET, POST, OPTIONS";
        private static final int DEFAULT_ACCESS_CONTROL_MAX_AGE = 86400;
        private static final ServerBootstrap DEFAULT_SERVER_BOOTSTRAP = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)new NioEventLoopGroup(1), (EventLoopGroup)new NioEventLoopGroup(0)).channel(NioServerSocketChannel.class)).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childOption(ChannelOption.SO_REUSEADDR, (Object)true);
        private SSLContext sslContext;
        private int port;
        private int maxFrameLength = 2048000;
        private boolean corsEnabled = false;
        private String accessControlAllowOrigin = "*";
        private String accessControlAllowMethods = "GET, POST, OPTIONS";
        private int accessControlMaxAge = 86400;
        private ServerStream serverStream;
        private ServerBootstrap serverBootstrap = DEFAULT_SERVER_BOOTSTRAP;

        private Config() {
        }

        private Config(Config other, Consumer<Config> modifier) {
            this.sslContext = other.sslContext;
            this.port = other.port;
            this.maxFrameLength = other.maxFrameLength;
            this.corsEnabled = other.corsEnabled;
            this.accessControlAllowOrigin = other.accessControlAllowOrigin;
            this.accessControlAllowMethods = other.accessControlAllowMethods;
            this.accessControlMaxAge = other.accessControlMaxAge;
            this.serverStream = other.serverStream;
            this.serverBootstrap = other.serverBootstrap;
            modifier.accept(this);
        }

        public SSLContext getSslContext() {
            return this.sslContext;
        }

        public Config setSslContext(SSLContext sslContext) {
            return new Config(this, config -> {
                config.sslContext = sslContext;
            });
        }

        public int getPort() {
            return this.port;
        }

        public Config setPort(int port) {
            return new Config(this, config -> {
                config.port = port;
            });
        }

        public int getMaxFrameLength() {
            return this.maxFrameLength;
        }

        public Config setMaxFrameLength(int maxFrameLength) {
            return new Config(this, config -> {
                config.maxFrameLength = maxFrameLength;
            });
        }

        public boolean isCorsEnabled() {
            return this.corsEnabled;
        }

        public Config setCorsEnabled(boolean corsEnabled) {
            return new Config(this, config -> {
                config.corsEnabled = corsEnabled;
            });
        }

        public String getAccessControlAllowOrigin() {
            return this.accessControlAllowOrigin;
        }

        public Config setAccessControlAllowOrigin(String accessControlAllowOrigin) {
            return new Config(this, config -> {
                config.accessControlAllowOrigin = accessControlAllowOrigin;
            });
        }

        public String getAccessControlAllowMethods() {
            return this.accessControlAllowMethods;
        }

        public Config setAccessControlAllowMethods(String accessControlAllowMethods) {
            return new Config(this, config -> {
                config.accessControlAllowMethods = accessControlAllowMethods;
            });
        }

        public int getAccessControlMaxAge() {
            return this.accessControlMaxAge;
        }

        public Config setAccessControlMaxAge(int accessControlMaxAge) {
            return new Config(this, config -> {
                config.accessControlMaxAge = accessControlMaxAge;
            });
        }

        public ServerStream getServerStream() {
            return this.serverStream;
        }

        public Config setServerStream(ServerStream serverStream) {
            return new Config(this, config -> {
                config.serverStream = serverStream;
            });
        }

        public ServerBootstrap getServerBootstrap() {
            return this.serverBootstrap;
        }

        public Config setServerBootstrap(ServerBootstrap serverBootstrap) {
            return new Config(this, config -> {
                config.serverBootstrap = serverBootstrap;
            });
        }
    }
}

