/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.gateway.http;

import com.google.common.collect.ImmutableList;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.scalecube.ipc.ErrorData;
import io.scalecube.ipc.Qualifier;
import io.scalecube.ipc.codec.JsonCodec;
import java.util.Collections;
import java.util.List;

public final class HttpCodecUtil {
    private static final List<String> ERROR_DATA_FIELDS = ImmutableList.of((Object)"errorCode", (Object)"message");

    private HttpCodecUtil() {
    }

    public static FullHttpResponse emptyResponse() {
        return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NO_CONTENT, Unpooled.EMPTY_BUFFER);
    }

    public static FullHttpResponse okResponse(ByteBuf body) {
        return HttpCodecUtil.toHttpResponse(HttpResponseStatus.OK, body);
    }

    public static FullHttpResponse errorResponse(Qualifier qualifier, ErrorData errordata) {
        return HttpCodecUtil.errorResponse(qualifier, HttpCodecUtil.encodeErrorData(errordata));
    }

    public static FullHttpResponse errorResponse(Qualifier qualifier, ByteBuf buf) {
        return HttpCodecUtil.toHttpResponse(HttpCodecUtil.toErrorStatus(qualifier), buf);
    }

    public static FullHttpResponse emptyErrorResponse(Qualifier qualifier) {
        return HttpCodecUtil.toHttpResponse(HttpCodecUtil.toErrorStatus(qualifier), Unpooled.EMPTY_BUFFER);
    }

    public static FullHttpResponse toHttpResponse(HttpResponseStatus status, ByteBuf content) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, content);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_JSON);
        response.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, (Object)"*");
        HttpUtil.setKeepAlive((HttpMessage)response, (boolean)true);
        HttpUtil.setContentLength((HttpMessage)response, (long)content.readableBytes());
        return response;
    }

    public static HttpResponseStatus toErrorStatus(Qualifier qualifier) {
        int code;
        if (!"io.scalecube.ipc.error".equalsIgnoreCase(qualifier.getNamespace())) {
            throw new IllegalArgumentException("Not an error qualifier: " + qualifier);
        }
        try {
            code = Integer.valueOf(qualifier.getAction());
        }
        catch (Exception throwable) {
            throw new IllegalArgumentException("Not an error qualifier: " + qualifier);
        }
        return HttpResponseStatus.valueOf((int)code);
    }

    private static ByteBuf encodeErrorData(ErrorData errorData) {
        ByteBuf buf = ByteBufAllocator.DEFAULT.buffer();
        try {
            JsonCodec.encode((ByteBuf)buf, ERROR_DATA_FIELDS, Collections.emptyList(), fieldName -> {
                switch (fieldName) {
                    case "errorCode": {
                        return errorData.getErrorCode();
                    }
                    case "message": {
                        return errorData.getMessage();
                    }
                }
                return null;
            });
            return buf;
        }
        catch (Exception e) {
            buf.release();
            return Unpooled.EMPTY_BUFFER;
        }
    }
}

