/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.gateway.socketio;

import io.netty.buffer.ByteBuf;
import io.scalecube.cluster.membership.IdGenerator;
import io.scalecube.ipc.ChannelContext;
import io.scalecube.ipc.EventStream;
import io.scalecube.ipc.ServiceMessage;
import io.scalecube.ipc.codec.ServiceMessageCodec;
import io.scalecube.ipc.netty.ChannelSupport;
import io.scalecube.socketio.Session;
import io.scalecube.socketio.SocketIOListener;
import io.scalecube.transport.Address;
import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GatewaySocketIoListener
implements SocketIOListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(GatewaySocketIoListener.class);
    private final EventStream eventStream;
    private final ConcurrentMap<String, String> sessionIdToChannelContextId = new ConcurrentHashMap<String, String>();

    public GatewaySocketIoListener(EventStream eventStream) {
        this.eventStream = eventStream;
    }

    public void onConnect(Session session) {
        String channelContextId = IdGenerator.generateId();
        this.sessionIdToChannelContextId.put(session.getSessionId(), channelContextId);
        InetSocketAddress remoteAddress = (InetSocketAddress)session.getRemoteAddress();
        String host = remoteAddress.getAddress().getHostAddress();
        int port = remoteAddress.getPort();
        ChannelContext channelContext = ChannelContext.create((String)channelContextId, (Address)Address.create((String)host, (int)port));
        this.eventStream.subscribe(channelContext);
        channelContext.listenMessageWrite().subscribe(event -> {
            ServiceMessage message = (ServiceMessage)event.getMessage().get();
            ByteBuf buf = ServiceMessageCodec.encode((ServiceMessage)message);
            ChannelSupport.releaseRefCount((Object)message.getData());
            try {
                session.send(buf);
                channelContext.postWriteSuccess(message);
            }
            catch (Exception throwable) {
                channelContext.postWriteError((Throwable)throwable, message);
            }
        }, throwable -> {
            LOGGER.error("Fatal exception occured on channel context: {}, cause: {}", (Object)channelContext.getId(), throwable);
            session.disconnect();
        });
    }

    public void onMessage(Session session, ByteBuf buf) {
        String channelContextId = (String)this.sessionIdToChannelContextId.get(session.getSessionId());
        if (channelContextId == null) {
            LOGGER.error("Can't find channel context id by session id: {}", (Object)session.getSessionId());
            ChannelSupport.releaseRefCount((Object)buf);
            session.disconnect();
            return;
        }
        ChannelContext channelContext = ChannelContext.getIfExist((String)channelContextId);
        if (channelContext == null) {
            ChannelSupport.releaseRefCount((Object)buf);
            LOGGER.error("Failed to handle message, channel context is null by id: {}", (Object)channelContextId);
            session.disconnect();
            return;
        }
        try {
            channelContext.postReadSuccess(ServiceMessageCodec.decode((ByteBuf)buf));
        }
        catch (Exception throwable) {
            ChannelSupport.releaseRefCount((Object)buf);
            channelContext.postReadError((Throwable)throwable);
        }
    }

    public void onDisconnect(Session session) {
        String channelContextId = (String)this.sessionIdToChannelContextId.remove(session.getSessionId());
        if (channelContextId == null) {
            LOGGER.error("Can't find channel context id by session id: {}", (Object)session.getSessionId());
            return;
        }
        ChannelContext.closeIfExist((String)channelContextId);
    }
}

