/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.gateway.socketio;

import io.netty.bootstrap.ServerBootstrap;
import io.scalecube.gateway.socketio.GatewaySocketIoListener;
import io.scalecube.ipc.EventStream;
import io.scalecube.ipc.ServerStream;
import io.scalecube.socketio.ServerConfiguration;
import io.scalecube.socketio.SocketIOListener;
import io.scalecube.socketio.SocketIOServer;
import java.util.function.Consumer;
import javax.net.ssl.SSLContext;

public final class GatewaySocketIoServer {
    private final Config config;
    private SocketIOServer socketioServer;

    private GatewaySocketIoServer(Config config) {
        this.config = config;
    }

    public static GatewaySocketIoServer onPort(int port, ServerStream serverStream) {
        Config config = new Config();
        config.port = port;
        config.serverStream = serverStream;
        return new GatewaySocketIoServer(config);
    }

    public GatewaySocketIoServer withServerBootstrap(ServerBootstrap serverBootstrap) {
        return new GatewaySocketIoServer(this.config.setServerBootstrap(serverBootstrap));
    }

    public GatewaySocketIoServer withSsl(SSLContext sslContext) {
        return new GatewaySocketIoServer(this.config.setSslContext(sslContext));
    }

    public GatewaySocketIoServer withCloseTimeout(int closeTimeout) {
        return new GatewaySocketIoServer(this.config.setCloseTimeout(closeTimeout));
    }

    public GatewaySocketIoServer withHeartbeatInterval(int heartbeatInterval) {
        return new GatewaySocketIoServer(this.config.setHeartbeatInterval(heartbeatInterval));
    }

    public GatewaySocketIoServer withHeartbeatTimeout(int heartbeatTimeout) {
        return new GatewaySocketIoServer(this.config.setHeartbeatTimeout(heartbeatTimeout));
    }

    public GatewaySocketIoServer withMaxWebSocketFrameSize(int maxWebSocketFrameSize) {
        return new GatewaySocketIoServer(this.config.setMaxWebSocketFrameSize(maxWebSocketFrameSize));
    }

    public GatewaySocketIoServer withAlwaysSecureWebSocketLocation(boolean alwaysSecureWebSocketLocation) {
        return new GatewaySocketIoServer(this.config.setAlwaysSecureWebSocketLocation(alwaysSecureWebSocketLocation));
    }

    public GatewaySocketIoServer withRemoteAddressHeader(String remoteAddressHeader) {
        return new GatewaySocketIoServer(this.config.setRemoteAddressHeader(remoteAddressHeader));
    }

    public GatewaySocketIoServer withTransports(String transports) {
        return new GatewaySocketIoServer(this.config.setTransports(transports));
    }

    public synchronized void start() {
        if (this.socketioServer != null && this.socketioServer.isStarted()) {
            throw new IllegalStateException("Failed to start server: already started");
        }
        ServerConfiguration configuration = ServerConfiguration.builder().port(this.config.port).sslContext(this.config.sslContext).closeTimeout(this.config.closeTimeout).alwaysSecureWebSocketLocation(this.config.alwaysSecureWebSocketLocation).heartbeatInterval(this.config.heartbeatInterval).heartbeatTimeout(this.config.heartbeatTimeout).maxWebSocketFrameSize(this.config.maxWebSocketFrameSize).remoteAddressHeader(this.config.remoteAddressHeader).transports(this.config.transports).eventExecutorEnabled(false).build();
        SocketIOServer server = SocketIOServer.newInstance((ServerConfiguration)configuration);
        server.setListener((SocketIOListener)new GatewaySocketIoListener((EventStream)this.config.serverStream));
        if (this.config.serverBootstrap != null) {
            server.setServerBootstrapFactory(() -> this.config.serverBootstrap);
        }
        server.start();
        this.socketioServer = server;
    }

    public synchronized void stop() {
        if (this.socketioServer != null && this.socketioServer.isStopped()) {
            throw new IllegalStateException("Failed to stop server: already stopped");
        }
        if (this.socketioServer != null) {
            this.socketioServer.stop();
        }
    }

    public static class Config {
        private static final int DEFAULT_MAX_FRAME_LENGTH = 65536;
        private static final int SOCKETIO_DEFAULT_HEARTBEAT_TIMEOUT = 60;
        private static final int SOCKETIO_DEFAULT_HEARTBEAT_INTERVAL = 25;
        private static final int SOCKETIO_DEFAULT_CLOSE_TIMEOUT = 60;
        private static final String SOCKETIO_DEFAULT_TRANSPORTS = "websocket,flashsocket,xhr-polling,jsonp-polling";
        private static final boolean SOCKETIO_DEFAULT_ALWAYS_SECURE_WEB_SOCKET_LOCATION = false;
        private static final String SOCKETIO_DEFAULT_REMOTE_ADDRESS_HEADER = "X-Forwarded-For";
        private static final boolean EVENT_EXECUTOR_ENABLED = false;
        private SSLContext sslContext;
        private int port;
        private String transports = "websocket,flashsocket,xhr-polling,jsonp-polling";
        private int heartbeatTimeout = 60;
        private int heartbeatInterval = 25;
        private int closeTimeout = 60;
        private int maxWebSocketFrameSize = 65536;
        private boolean alwaysSecureWebSocketLocation = false;
        private String remoteAddressHeader = "X-Forwarded-For";
        private ServerStream serverStream;
        private ServerBootstrap serverBootstrap = null;

        private Config() {
        }

        private Config(Config other, Consumer<Config> modifier) {
            this.sslContext = other.sslContext;
            this.port = other.port;
            this.transports = other.transports;
            this.heartbeatTimeout = other.heartbeatTimeout;
            this.heartbeatInterval = other.heartbeatInterval;
            this.closeTimeout = other.closeTimeout;
            this.maxWebSocketFrameSize = other.maxWebSocketFrameSize;
            this.alwaysSecureWebSocketLocation = other.alwaysSecureWebSocketLocation;
            this.remoteAddressHeader = other.remoteAddressHeader;
            this.serverStream = other.serverStream;
            this.serverBootstrap = other.serverBootstrap;
            modifier.accept(this);
        }

        public SSLContext getSslContext() {
            return this.sslContext;
        }

        public Config setSslContext(SSLContext sslContext) {
            return new Config(this, config -> {
                config.sslContext = sslContext;
            });
        }

        public int getPort() {
            return this.port;
        }

        public Config setPort(int port) {
            return new Config(this, config -> {
                config.port = port;
            });
        }

        public String getTransports() {
            return this.transports;
        }

        public Config setTransports(String transports) {
            return new Config(this, config -> {
                config.transports = transports;
            });
        }

        public int getHeartbeatTimeout() {
            return this.heartbeatTimeout;
        }

        public Config setHeartbeatTimeout(int heartbeatTimeout) {
            return new Config(this, config -> {
                config.heartbeatTimeout = heartbeatTimeout;
            });
        }

        public int getHeartbeatInterval() {
            return this.heartbeatInterval;
        }

        public Config setHeartbeatInterval(int heartbeatInterval) {
            return new Config(this, config -> {
                config.heartbeatInterval = heartbeatInterval;
            });
        }

        public int getCloseTimeout() {
            return this.closeTimeout;
        }

        public Config setCloseTimeout(int closeTimeout) {
            return new Config(this, config -> {
                config.closeTimeout = closeTimeout;
            });
        }

        public int getMaxWebSocketFrameSize() {
            return this.maxWebSocketFrameSize;
        }

        public Config setMaxWebSocketFrameSize(int maxWebSocketFrameSize) {
            return new Config(this, config -> {
                config.maxWebSocketFrameSize = maxWebSocketFrameSize;
            });
        }

        public boolean isAlwaysSecureWebSocketLocation() {
            return this.alwaysSecureWebSocketLocation;
        }

        public Config setAlwaysSecureWebSocketLocation(boolean alwaysSecureWebSocketLocation) {
            return new Config(this, config -> {
                config.alwaysSecureWebSocketLocation = alwaysSecureWebSocketLocation;
            });
        }

        public String getRemoteAddressHeader() {
            return this.remoteAddressHeader;
        }

        public Config setRemoteAddressHeader(String remoteAddressHeader) {
            return new Config(this, config -> {
                config.remoteAddressHeader = remoteAddressHeader;
            });
        }

        public ServerStream getServerStream() {
            return this.serverStream;
        }

        public Config setServerStream(ServerStream serverStream) {
            return new Config(this, config -> {
                config.serverStream = serverStream;
            });
        }

        public ServerBootstrap getServerBootstrap() {
            return this.serverBootstrap;
        }

        public Config setServerBootstrap(ServerBootstrap serverBootstrap) {
            return new Config(this, config -> {
                config.serverBootstrap = serverBootstrap;
            });
        }
    }
}

