/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.security.api;

import java.util.Map;

public class Profile {
    private final String userId;
    private final String tenant;
    private final String email;
    private final boolean isEmailVerified;
    private final String name;
    private final String familyName;
    private final String givenName;
    private final Map<String, Object> claims;

    private Profile(Builder builder) {
        this.userId = builder.userId;
        this.tenant = builder.tenant;
        this.email = builder.email;
        this.isEmailVerified = builder.isEmailVerified;
        this.name = builder.name;
        this.familyName = builder.familyName;
        this.givenName = builder.givenName;
        this.claims = builder.claims;
    }

    public String userId() {
        return this.userId;
    }

    public String tenant() {
        return this.tenant;
    }

    public String email() {
        return this.email;
    }

    public boolean isEmailVerified() {
        return this.isEmailVerified;
    }

    public String name() {
        return this.name;
    }

    public String familyName() {
        return this.familyName;
    }

    public String givenName() {
        return this.givenName;
    }

    public Object claim(String name) {
        return this.claims.getOrDefault(name, null);
    }

    public Map<String, Object> claims() {
        return this.claims;
    }

    public String toString() {
        return super.toString() + String.format(" [userId=%s, tenant=%s, email=%s, isEmailVerified=%s, name=%s, familyName=%s, givenName=%s, claims=%s]", this.userId, this.tenant, this.email, this.isEmailVerified, this.name, this.familyName, this.givenName, this.claims);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String userId;
        private String tenant;
        private String email;
        private boolean isEmailVerified;
        private String name;
        private String familyName;
        private String givenName;
        private Map<String, Object> claims;

        private Builder() {
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder tenant(String tenant) {
            this.tenant = tenant;
            return this;
        }

        public Builder email(String email) {
            this.email = email;
            return this;
        }

        public Builder emailVerified(Boolean emailVerified) {
            this.isEmailVerified = emailVerified != null ? emailVerified.booleanValue() : Boolean.FALSE.booleanValue();
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder familyName(String familyName) {
            this.familyName = familyName;
            return this;
        }

        public Builder givenName(String givenName) {
            this.givenName = givenName;
            return this;
        }

        public Builder claims(Map<String, Object> claims) {
            this.claims = claims;
            return this;
        }

        public Profile build() {
            return new Profile(this);
        }
    }
}

