/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.security.jwt;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwt;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.scalecube.security.api.Profile;
import io.scalecube.security.jwt.AuthenticationException;
import io.scalecube.security.jwt.JwtAuthenticator;
import io.scalecube.security.jwt.JwtKeyResolver;
import java.util.Map;
import reactor.core.publisher.Mono;

public final class DefaultJwtAuthenticator
implements JwtAuthenticator {
    private final JwtKeyResolver jwtKeyResolver;

    public DefaultJwtAuthenticator(JwtKeyResolver jwtKeyResolver) {
        this.jwtKeyResolver = jwtKeyResolver;
    }

    @Override
    public Mono<Profile> authenticate(String token) {
        return Mono.defer(() -> this.authenticate0(token)).onErrorMap(AuthenticationException::new);
    }

    private Mono<Profile> authenticate0(String token) {
        String tokenWithoutSignature = token.substring(0, token.lastIndexOf(".") + 1);
        JwtParser parser = Jwts.parser();
        Jwt claims = parser.parseClaimsJwt(tokenWithoutSignature);
        return this.jwtKeyResolver.resolve((Map<String, Object>)claims.getHeader()).map(key -> (Claims)parser.setSigningKey(key).parseClaimsJws(token).getBody()).map(this::profileFromClaims);
    }
}

