/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services;

import io.scalecube.net.Address;
import io.scalecube.services.ServiceEndpoint;
import io.scalecube.services.ServiceMethodDefinition;
import io.scalecube.services.ServiceRegistration;
import io.scalecube.services.api.Qualifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;

public class ServiceReference {
    private final String qualifier;
    private final String endpointId;
    private final String namespace;
    private final Set<String> contentTypes;
    private final Map<String, String> tags;
    private final String action;
    private final Address address;
    private final boolean isSecured;

    public ServiceReference(ServiceMethodDefinition serviceMethodDefinition, ServiceRegistration serviceRegistration, ServiceEndpoint serviceEndpoint) {
        this.endpointId = serviceEndpoint.id();
        this.namespace = serviceRegistration.namespace();
        this.contentTypes = Collections.unmodifiableSet(serviceEndpoint.contentTypes());
        this.tags = this.mergeTags(serviceMethodDefinition, serviceRegistration, serviceEndpoint);
        this.action = serviceMethodDefinition.action();
        this.qualifier = Qualifier.asString(this.namespace, this.action);
        this.address = serviceEndpoint.address();
        this.isSecured = serviceMethodDefinition.isSecured();
    }

    public String qualifier() {
        return this.qualifier;
    }

    public String oldQualifier() {
        return "/" + this.qualifier();
    }

    public String endpointId() {
        return this.endpointId;
    }

    public String namespace() {
        return this.namespace;
    }

    public Set<String> contentTypes() {
        return this.contentTypes;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public String action() {
        return this.action;
    }

    public Address address() {
        return this.address;
    }

    public boolean isSecured() {
        return this.isSecured;
    }

    private Map<String, String> mergeTags(ServiceMethodDefinition serviceMethodDefinition, ServiceRegistration serviceRegistration, ServiceEndpoint serviceEndpoint) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.putAll(serviceEndpoint.tags());
        tags.putAll(serviceRegistration.tags());
        tags.putAll(serviceMethodDefinition.tags());
        return tags;
    }

    public String toString() {
        return new StringJoiner(", ", ServiceReference.class.getSimpleName() + "[", "]").add("endpointId=" + this.endpointId).add("address=" + this.address).add("qualifier=" + this.qualifier).add("contentTypes=" + this.contentTypes).add("tags=" + this.tags).add("isSecured=" + this.isSecured).toString();
    }
}

