/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.gateway;

import io.scalecube.config.ConfigRegistry;
import io.scalecube.config.ConfigRegistrySettings;
import io.scalecube.config.audit.ConfigEventListener;
import io.scalecube.config.audit.Slf4JConfigEventListener;
import io.scalecube.config.source.ClassPathConfigSource;
import io.scalecube.config.source.ConfigSource;
import io.scalecube.config.source.SystemEnvironmentConfigSource;
import io.scalecube.config.source.SystemPropertiesConfigSource;
import io.scalecube.net.Address;
import io.scalecube.services.Microservices;
import io.scalecube.services.ServiceEndpoint;
import io.scalecube.services.discovery.ScalecubeServiceDiscovery;
import io.scalecube.services.discovery.api.ServiceDiscovery;
import io.scalecube.services.gateway.http.HttpGateway;
import io.scalecube.services.gateway.rsocket.RSocketGateway;
import io.scalecube.services.gateway.ws.WebsocketGateway;
import io.scalecube.services.transport.rsocket.RSocketServerTransportFactory;
import io.scalecube.services.transport.rsocket.RSocketServiceTransport;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GatewayRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(GatewayRunner.class);
    private static final String DECORATOR = "#######################################################################";

    public static void main(String[] args) {
        ConfigRegistry configRegistry = ConfigBootstrap.configRegistry();
        Config config = (Config)configRegistry.objectProperty("io.scalecube.services.gateway", Config.class).value().orElseThrow(() -> new IllegalStateException("Couldn't load config"));
        LOGGER.info(DECORATOR);
        LOGGER.info("Starting Gateway on {}", (Object)config);
        LOGGER.info(DECORATOR);
        Microservices.builder().discovery("gateway", serviceEndpoint -> GatewayRunner.serviceDiscovery(serviceEndpoint, config)).transport(() -> GatewayRunner.newServiceTransport(config)).gateway(opts -> new WebsocketGateway(opts.id("ws").port(7070))).gateway(opts -> new HttpGateway(opts.id("http").port(8080)).corsEnabled(true).corsConfig(cors -> cors.allowedRequestHeaders(new String[]{"*"}))).gateway(opts -> new RSocketGateway(opts.id("rsws").port(9090))).startAwait().onShutdown().block();
    }

    private static RSocketServiceTransport newServiceTransport(Config config) {
        return new RSocketServiceTransport().serverTransportFactory(RSocketServerTransportFactory.tcp((int)config.servicePort()));
    }

    private static ServiceDiscovery serviceDiscovery(ServiceEndpoint serviceEndpoint, Config config) {
        return new ScalecubeServiceDiscovery(serviceEndpoint).options(clusterConfig -> clusterConfig.membership(opts -> opts.seedMembers(config.seedAddresses())).transport(opts -> opts.port(config.discoveryPort())).externalHost(config.externalHost()).externalPort(config.externalPort()));
    }

    public static class ConfigBootstrap {
        private static final Pattern CONFIG_PATTERN = Pattern.compile("(.*)config(.*)?\\.properties");
        private static final Predicate<Path> PATH_PREDICATE = path -> CONFIG_PATTERN.matcher(path.toString()).matches();

        public static ConfigRegistry configRegistry() {
            return ConfigRegistry.create((ConfigRegistrySettings)ConfigRegistrySettings.builder().addListener((ConfigEventListener)new Slf4JConfigEventListener()).addLastSource("sys_prop", (ConfigSource)new SystemPropertiesConfigSource()).addLastSource("env_var", (ConfigSource)new SystemEnvironmentConfigSource()).addLastSource("cp", (ConfigSource)new ClassPathConfigSource(PATH_PREDICATE)).jmxEnabled(false).build());
        }
    }

    public static class Config {
        private int servicePort;
        private int discoveryPort;
        private List<String> seeds;
        private String externalHost;
        private Integer externalPort;

        public int servicePort() {
            return this.servicePort;
        }

        public int discoveryPort() {
            return this.discoveryPort;
        }

        public List<String> seeds() {
            return this.seeds;
        }

        public Address[] seedAddresses() {
            return Optional.ofNullable(this.seeds()).map(seeds -> (Address[])seeds.stream().map(Address::from).toArray(Address[]::new)).orElse(new Address[0]);
        }

        public String externalHost() {
            return this.externalHost;
        }

        public Integer externalPort() {
            return this.externalPort;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Config{");
            sb.append("servicePort=").append(this.servicePort);
            sb.append(", discoveryPort=").append(this.discoveryPort);
            sb.append(", seeds=").append(this.seeds);
            sb.append(", externalHost=").append(this.externalHost);
            sb.append(", externalPort=").append(this.externalPort);
            sb.append('}');
            return sb.toString();
        }
    }
}

